/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.security.fluent.AssessmentsMetadatasClient;
import com.azure.resourcemanager.security.fluent.models.SecurityAssessmentMetadataResponseInner;
import com.azure.resourcemanager.security.implementation.SecurityCenterImpl;
import com.azure.resourcemanager.security.models.SecurityAssessmentMetadataResponseList;
import reactor.core.publisher.Mono;

public final class AssessmentsMetadatasClientImpl
implements AssessmentsMetadatasClient {
    private final AssessmentsMetadatasService service;
    private final SecurityCenterImpl client;

    AssessmentsMetadatasClientImpl(SecurityCenterImpl client) {
        this.service = (AssessmentsMetadatasService)RestProxy.create(AssessmentsMetadatasService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SecurityAssessmentMetadataResponseInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String apiVersion = "2021-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2021-06-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecurityAssessmentMetadataResponseList)res.getValue()).value(), ((SecurityAssessmentMetadataResponseList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SecurityAssessmentMetadataResponseInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String apiVersion = "2021-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2021-06-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecurityAssessmentMetadataResponseList)res.getValue()).value(), ((SecurityAssessmentMetadataResponseList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SecurityAssessmentMetadataResponseInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync(), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SecurityAssessmentMetadataResponseInner> listAsync(Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecurityAssessmentMetadataResponseInner> list() {
        return new PagedIterable(this.listAsync());
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecurityAssessmentMetadataResponseInner> list(Context context) {
        return new PagedIterable(this.listAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SecurityAssessmentMetadataResponseInner>> getWithResponseAsync(String assessmentMetadataName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (assessmentMetadataName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter assessmentMetadataName is required and cannot be null."));
        }
        String apiVersion = "2021-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2021-06-01", assessmentMetadataName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SecurityAssessmentMetadataResponseInner>> getWithResponseAsync(String assessmentMetadataName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (assessmentMetadataName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter assessmentMetadataName is required and cannot be null."));
        }
        String apiVersion = "2021-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), "2021-06-01", assessmentMetadataName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SecurityAssessmentMetadataResponseInner> getAsync(String assessmentMetadataName) {
        return this.getWithResponseAsync(assessmentMetadataName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SecurityAssessmentMetadataResponseInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SecurityAssessmentMetadataResponseInner> getWithResponse(String assessmentMetadataName, Context context) {
        return (Response)this.getWithResponseAsync(assessmentMetadataName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SecurityAssessmentMetadataResponseInner get(String assessmentMetadataName) {
        return (SecurityAssessmentMetadataResponseInner)((Object)this.getWithResponse(assessmentMetadataName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SecurityAssessmentMetadataResponseInner>> listBySubscriptionSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySubscription(this.client.getEndpoint(), "2021-06-01", this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecurityAssessmentMetadataResponseList)res.getValue()).value(), ((SecurityAssessmentMetadataResponseList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SecurityAssessmentMetadataResponseInner>> listBySubscriptionSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySubscription(this.client.getEndpoint(), "2021-06-01", this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecurityAssessmentMetadataResponseList)res.getValue()).value(), ((SecurityAssessmentMetadataResponseList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SecurityAssessmentMetadataResponseInner> listBySubscriptionAsync() {
        return new PagedFlux(() -> this.listBySubscriptionSinglePageAsync(), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SecurityAssessmentMetadataResponseInner> listBySubscriptionAsync(Context context) {
        return new PagedFlux(() -> this.listBySubscriptionSinglePageAsync(context), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecurityAssessmentMetadataResponseInner> listBySubscription() {
        return new PagedIterable(this.listBySubscriptionAsync());
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SecurityAssessmentMetadataResponseInner> listBySubscription(Context context) {
        return new PagedIterable(this.listBySubscriptionAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SecurityAssessmentMetadataResponseInner>> getInSubscriptionWithResponseAsync(String assessmentMetadataName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (assessmentMetadataName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter assessmentMetadataName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getInSubscription(this.client.getEndpoint(), "2021-06-01", assessmentMetadataName, this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SecurityAssessmentMetadataResponseInner>> getInSubscriptionWithResponseAsync(String assessmentMetadataName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (assessmentMetadataName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter assessmentMetadataName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getInSubscription(this.client.getEndpoint(), "2021-06-01", assessmentMetadataName, this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SecurityAssessmentMetadataResponseInner> getInSubscriptionAsync(String assessmentMetadataName) {
        return this.getInSubscriptionWithResponseAsync(assessmentMetadataName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SecurityAssessmentMetadataResponseInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SecurityAssessmentMetadataResponseInner> getInSubscriptionWithResponse(String assessmentMetadataName, Context context) {
        return (Response)this.getInSubscriptionWithResponseAsync(assessmentMetadataName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SecurityAssessmentMetadataResponseInner getInSubscription(String assessmentMetadataName) {
        return (SecurityAssessmentMetadataResponseInner)((Object)this.getInSubscriptionWithResponse(assessmentMetadataName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SecurityAssessmentMetadataResponseInner>> createInSubscriptionWithResponseAsync(String assessmentMetadataName, SecurityAssessmentMetadataResponseInner assessmentMetadata) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (assessmentMetadataName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter assessmentMetadataName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (assessmentMetadata == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter assessmentMetadata is required and cannot be null."));
        }
        assessmentMetadata.validate();
        String apiVersion = "2021-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createInSubscription(this.client.getEndpoint(), "2021-06-01", assessmentMetadataName, this.client.getSubscriptionId(), assessmentMetadata, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SecurityAssessmentMetadataResponseInner>> createInSubscriptionWithResponseAsync(String assessmentMetadataName, SecurityAssessmentMetadataResponseInner assessmentMetadata, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (assessmentMetadataName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter assessmentMetadataName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (assessmentMetadata == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter assessmentMetadata is required and cannot be null."));
        }
        assessmentMetadata.validate();
        String apiVersion = "2021-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createInSubscription(this.client.getEndpoint(), "2021-06-01", assessmentMetadataName, this.client.getSubscriptionId(), assessmentMetadata, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SecurityAssessmentMetadataResponseInner> createInSubscriptionAsync(String assessmentMetadataName, SecurityAssessmentMetadataResponseInner assessmentMetadata) {
        return this.createInSubscriptionWithResponseAsync(assessmentMetadataName, assessmentMetadata).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SecurityAssessmentMetadataResponseInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SecurityAssessmentMetadataResponseInner> createInSubscriptionWithResponse(String assessmentMetadataName, SecurityAssessmentMetadataResponseInner assessmentMetadata, Context context) {
        return (Response)this.createInSubscriptionWithResponseAsync(assessmentMetadataName, assessmentMetadata, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SecurityAssessmentMetadataResponseInner createInSubscription(String assessmentMetadataName, SecurityAssessmentMetadataResponseInner assessmentMetadata) {
        return (SecurityAssessmentMetadataResponseInner)((Object)this.createInSubscriptionWithResponse(assessmentMetadataName, assessmentMetadata, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteInSubscriptionWithResponseAsync(String assessmentMetadataName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (assessmentMetadataName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter assessmentMetadataName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-06-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteInSubscription(this.client.getEndpoint(), "2021-06-01", assessmentMetadataName, this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteInSubscriptionWithResponseAsync(String assessmentMetadataName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (assessmentMetadataName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter assessmentMetadataName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-06-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteInSubscription(this.client.getEndpoint(), "2021-06-01", assessmentMetadataName, this.client.getSubscriptionId(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteInSubscriptionAsync(String assessmentMetadataName) {
        return this.deleteInSubscriptionWithResponseAsync(assessmentMetadataName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteInSubscriptionWithResponse(String assessmentMetadataName, Context context) {
        return (Response)this.deleteInSubscriptionWithResponseAsync(assessmentMetadataName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteInSubscription(String assessmentMetadataName) {
        this.deleteInSubscriptionWithResponse(assessmentMetadataName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SecurityAssessmentMetadataResponseInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecurityAssessmentMetadataResponseList)res.getValue()).value(), ((SecurityAssessmentMetadataResponseList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SecurityAssessmentMetadataResponseInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecurityAssessmentMetadataResponseList)res.getValue()).value(), ((SecurityAssessmentMetadataResponseList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SecurityAssessmentMetadataResponseInner>> listBySubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecurityAssessmentMetadataResponseList)res.getValue()).value(), ((SecurityAssessmentMetadataResponseList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SecurityAssessmentMetadataResponseInner>> listBySubscriptionNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecurityAssessmentMetadataResponseList)res.getValue()).value(), ((SecurityAssessmentMetadataResponseList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SecurityCenterAssess")
    public static interface AssessmentsMetadatasService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Security/assessmentMetadata")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SecurityAssessmentMetadataResponseList>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Security/assessmentMetadata/{assessmentMetadataName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SecurityAssessmentMetadataResponseInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="assessmentMetadataName") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/assessmentMetadata")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SecurityAssessmentMetadataResponseList>> listBySubscription(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/assessmentMetadata/{assessmentMetadataName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SecurityAssessmentMetadataResponseInner>> getInSubscription(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="assessmentMetadataName") String var3, @PathParam(value="subscriptionId") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/assessmentMetadata/{assessmentMetadataName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SecurityAssessmentMetadataResponseInner>> createInSubscription(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="assessmentMetadataName") String var3, @PathParam(value="subscriptionId") String var4, @BodyParam(value="application/json") SecurityAssessmentMetadataResponseInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/assessmentMetadata/{assessmentMetadataName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> deleteInSubscription(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="assessmentMetadataName") String var3, @PathParam(value="subscriptionId") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SecurityAssessmentMetadataResponseList>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SecurityAssessmentMetadataResponseList>> listBySubscriptionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

