/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.AssessmentsMetadatasClient;
import com.azure.resourcemanager.security.fluent.models.SecurityAssessmentMetadataResponseInner;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.implementation.SecurityAssessmentMetadataResponseImpl;
import com.azure.resourcemanager.security.models.AssessmentsMetadatas;
import com.azure.resourcemanager.security.models.SecurityAssessmentMetadataResponse;

public final class AssessmentsMetadatasImpl
implements AssessmentsMetadatas {
    private static final ClientLogger LOGGER = new ClientLogger(AssessmentsMetadatasImpl.class);
    private final AssessmentsMetadatasClient innerClient;
    private final SecurityManager serviceManager;

    public AssessmentsMetadatasImpl(AssessmentsMetadatasClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<SecurityAssessmentMetadataResponse> list() {
        PagedIterable<SecurityAssessmentMetadataResponseInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SecurityAssessmentMetadataResponseImpl((SecurityAssessmentMetadataResponseInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SecurityAssessmentMetadataResponse> list(Context context) {
        PagedIterable<SecurityAssessmentMetadataResponseInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SecurityAssessmentMetadataResponseImpl((SecurityAssessmentMetadataResponseInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<SecurityAssessmentMetadataResponse> getWithResponse(String assessmentMetadataName, Context context) {
        Response<SecurityAssessmentMetadataResponseInner> inner = this.serviceClient().getWithResponse(assessmentMetadataName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SecurityAssessmentMetadataResponseImpl((SecurityAssessmentMetadataResponseInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SecurityAssessmentMetadataResponse get(String assessmentMetadataName) {
        SecurityAssessmentMetadataResponseInner inner = this.serviceClient().get(assessmentMetadataName);
        if (inner != null) {
            return new SecurityAssessmentMetadataResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<SecurityAssessmentMetadataResponse> listBySubscription() {
        PagedIterable<SecurityAssessmentMetadataResponseInner> inner = this.serviceClient().listBySubscription();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SecurityAssessmentMetadataResponseImpl((SecurityAssessmentMetadataResponseInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SecurityAssessmentMetadataResponse> listBySubscription(Context context) {
        PagedIterable<SecurityAssessmentMetadataResponseInner> inner = this.serviceClient().listBySubscription(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SecurityAssessmentMetadataResponseImpl((SecurityAssessmentMetadataResponseInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<SecurityAssessmentMetadataResponse> getInSubscriptionWithResponse(String assessmentMetadataName, Context context) {
        Response<SecurityAssessmentMetadataResponseInner> inner = this.serviceClient().getInSubscriptionWithResponse(assessmentMetadataName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SecurityAssessmentMetadataResponseImpl((SecurityAssessmentMetadataResponseInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SecurityAssessmentMetadataResponse getInSubscription(String assessmentMetadataName) {
        SecurityAssessmentMetadataResponseInner inner = this.serviceClient().getInSubscription(assessmentMetadataName);
        if (inner != null) {
            return new SecurityAssessmentMetadataResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteInSubscriptionWithResponse(String assessmentMetadataName, Context context) {
        return this.serviceClient().deleteInSubscriptionWithResponse(assessmentMetadataName, context);
    }

    @Override
    public void deleteInSubscription(String assessmentMetadataName) {
        this.serviceClient().deleteInSubscription(assessmentMetadataName);
    }

    @Override
    public SecurityAssessmentMetadataResponse getInSubscriptionById(String id) {
        String assessmentMetadataName = ResourceManagerUtils.getValueFromIdByName(id, "assessmentMetadata");
        if (assessmentMetadataName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'assessmentMetadata'.", id)));
        }
        return (SecurityAssessmentMetadataResponse)this.getInSubscriptionWithResponse(assessmentMetadataName, Context.NONE).getValue();
    }

    @Override
    public Response<SecurityAssessmentMetadataResponse> getInSubscriptionByIdWithResponse(String id, Context context) {
        String assessmentMetadataName = ResourceManagerUtils.getValueFromIdByName(id, "assessmentMetadata");
        if (assessmentMetadataName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'assessmentMetadata'.", id)));
        }
        return this.getInSubscriptionWithResponse(assessmentMetadataName, context);
    }

    @Override
    public void deleteInSubscriptionById(String id) {
        String assessmentMetadataName = ResourceManagerUtils.getValueFromIdByName(id, "assessmentMetadata");
        if (assessmentMetadataName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'assessmentMetadata'.", id)));
        }
        this.deleteInSubscriptionWithResponse(assessmentMetadataName, Context.NONE);
    }

    @Override
    public Response<Void> deleteInSubscriptionByIdWithResponse(String id, Context context) {
        String assessmentMetadataName = ResourceManagerUtils.getValueFromIdByName(id, "assessmentMetadata");
        if (assessmentMetadataName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'assessmentMetadata'.", id)));
        }
        return this.deleteInSubscriptionWithResponse(assessmentMetadataName, context);
    }

    private AssessmentsMetadatasClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public SecurityAssessmentMetadataResponseImpl define(String name) {
        return new SecurityAssessmentMetadataResponseImpl(name, this.manager());
    }
}

