/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.models.AzureDevOpsOrgInner;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.AzureDevOpsOrg;
import com.azure.resourcemanager.security.models.AzureDevOpsOrgProperties;

public final class AzureDevOpsOrgImpl
implements AzureDevOpsOrg,
AzureDevOpsOrg.Definition,
AzureDevOpsOrg.Update {
    private AzureDevOpsOrgInner innerObject;
    private final SecurityManager serviceManager;
    private String resourceGroupName;
    private String securityConnectorName;
    private String orgName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public AzureDevOpsOrgProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public AzureDevOpsOrgInner innerModel() {
        return this.innerObject;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public AzureDevOpsOrgImpl withExistingSecurityConnector(String resourceGroupName, String securityConnectorName) {
        this.resourceGroupName = resourceGroupName;
        this.securityConnectorName = securityConnectorName;
        return this;
    }

    @Override
    public AzureDevOpsOrg create() {
        this.innerObject = this.serviceManager.serviceClient().getAzureDevOpsOrgs().createOrUpdate(this.resourceGroupName, this.securityConnectorName, this.orgName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public AzureDevOpsOrg create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAzureDevOpsOrgs().createOrUpdate(this.resourceGroupName, this.securityConnectorName, this.orgName, this.innerModel(), context);
        return this;
    }

    AzureDevOpsOrgImpl(String name, SecurityManager serviceManager) {
        this.innerObject = new AzureDevOpsOrgInner();
        this.serviceManager = serviceManager;
        this.orgName = name;
    }

    @Override
    public AzureDevOpsOrgImpl update() {
        return this;
    }

    @Override
    public AzureDevOpsOrg apply() {
        this.innerObject = this.serviceManager.serviceClient().getAzureDevOpsOrgs().update(this.resourceGroupName, this.securityConnectorName, this.orgName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public AzureDevOpsOrg apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAzureDevOpsOrgs().update(this.resourceGroupName, this.securityConnectorName, this.orgName, this.innerModel(), context);
        return this;
    }

    AzureDevOpsOrgImpl(AzureDevOpsOrgInner innerObject, SecurityManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.securityConnectorName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "securityConnectors");
        this.orgName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "azureDevOpsOrgs");
    }

    @Override
    public AzureDevOpsOrg refresh() {
        this.innerObject = (AzureDevOpsOrgInner)((Object)this.serviceManager.serviceClient().getAzureDevOpsOrgs().getWithResponse(this.resourceGroupName, this.securityConnectorName, this.orgName, Context.NONE).getValue());
        return this;
    }

    @Override
    public AzureDevOpsOrg refresh(Context context) {
        this.innerObject = (AzureDevOpsOrgInner)((Object)this.serviceManager.serviceClient().getAzureDevOpsOrgs().getWithResponse(this.resourceGroupName, this.securityConnectorName, this.orgName, context).getValue());
        return this;
    }

    @Override
    public AzureDevOpsOrgImpl withProperties(AzureDevOpsOrgProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

