/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.AzureDevOpsOrgsClient;
import com.azure.resourcemanager.security.fluent.models.AzureDevOpsOrgInner;
import com.azure.resourcemanager.security.fluent.models.AzureDevOpsOrgListResponseInner;
import com.azure.resourcemanager.security.implementation.AzureDevOpsOrgImpl;
import com.azure.resourcemanager.security.implementation.AzureDevOpsOrgListResponseImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.AzureDevOpsOrg;
import com.azure.resourcemanager.security.models.AzureDevOpsOrgListResponse;
import com.azure.resourcemanager.security.models.AzureDevOpsOrgs;

public final class AzureDevOpsOrgsImpl
implements AzureDevOpsOrgs {
    private static final ClientLogger LOGGER = new ClientLogger(AzureDevOpsOrgsImpl.class);
    private final AzureDevOpsOrgsClient innerClient;
    private final SecurityManager serviceManager;

    public AzureDevOpsOrgsImpl(AzureDevOpsOrgsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<AzureDevOpsOrgListResponse> listAvailableWithResponse(String resourceGroupName, String securityConnectorName, Context context) {
        Response<AzureDevOpsOrgListResponseInner> inner = this.serviceClient().listAvailableWithResponse(resourceGroupName, securityConnectorName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AzureDevOpsOrgListResponseImpl((AzureDevOpsOrgListResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public AzureDevOpsOrgListResponse listAvailable(String resourceGroupName, String securityConnectorName) {
        AzureDevOpsOrgListResponseInner inner = this.serviceClient().listAvailable(resourceGroupName, securityConnectorName);
        if (inner != null) {
            return new AzureDevOpsOrgListResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<AzureDevOpsOrg> list(String resourceGroupName, String securityConnectorName) {
        PagedIterable<AzureDevOpsOrgInner> inner = this.serviceClient().list(resourceGroupName, securityConnectorName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AzureDevOpsOrgImpl((AzureDevOpsOrgInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AzureDevOpsOrg> list(String resourceGroupName, String securityConnectorName, Context context) {
        PagedIterable<AzureDevOpsOrgInner> inner = this.serviceClient().list(resourceGroupName, securityConnectorName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AzureDevOpsOrgImpl((AzureDevOpsOrgInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<AzureDevOpsOrg> getWithResponse(String resourceGroupName, String securityConnectorName, String orgName, Context context) {
        Response<AzureDevOpsOrgInner> inner = this.serviceClient().getWithResponse(resourceGroupName, securityConnectorName, orgName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AzureDevOpsOrgImpl((AzureDevOpsOrgInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public AzureDevOpsOrg get(String resourceGroupName, String securityConnectorName, String orgName) {
        AzureDevOpsOrgInner inner = this.serviceClient().get(resourceGroupName, securityConnectorName, orgName);
        if (inner != null) {
            return new AzureDevOpsOrgImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public AzureDevOpsOrg getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String securityConnectorName = ResourceManagerUtils.getValueFromIdByName(id, "securityConnectors");
        if (securityConnectorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'securityConnectors'.", id)));
        }
        String orgName = ResourceManagerUtils.getValueFromIdByName(id, "azureDevOpsOrgs");
        if (orgName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'azureDevOpsOrgs'.", id)));
        }
        return (AzureDevOpsOrg)this.getWithResponse(resourceGroupName, securityConnectorName, orgName, Context.NONE).getValue();
    }

    @Override
    public Response<AzureDevOpsOrg> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String securityConnectorName = ResourceManagerUtils.getValueFromIdByName(id, "securityConnectors");
        if (securityConnectorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'securityConnectors'.", id)));
        }
        String orgName = ResourceManagerUtils.getValueFromIdByName(id, "azureDevOpsOrgs");
        if (orgName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'azureDevOpsOrgs'.", id)));
        }
        return this.getWithResponse(resourceGroupName, securityConnectorName, orgName, context);
    }

    private AzureDevOpsOrgsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public AzureDevOpsOrgImpl define(String name) {
        return new AzureDevOpsOrgImpl(name, this.manager());
    }
}

