/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.AzureDevOpsProjectsClient;
import com.azure.resourcemanager.security.fluent.models.AzureDevOpsProjectInner;
import com.azure.resourcemanager.security.implementation.AzureDevOpsProjectImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.AzureDevOpsProject;
import com.azure.resourcemanager.security.models.AzureDevOpsProjects;

public final class AzureDevOpsProjectsImpl
implements AzureDevOpsProjects {
    private static final ClientLogger LOGGER = new ClientLogger(AzureDevOpsProjectsImpl.class);
    private final AzureDevOpsProjectsClient innerClient;
    private final SecurityManager serviceManager;

    public AzureDevOpsProjectsImpl(AzureDevOpsProjectsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<AzureDevOpsProject> list(String resourceGroupName, String securityConnectorName, String orgName) {
        PagedIterable<AzureDevOpsProjectInner> inner = this.serviceClient().list(resourceGroupName, securityConnectorName, orgName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AzureDevOpsProjectImpl((AzureDevOpsProjectInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AzureDevOpsProject> list(String resourceGroupName, String securityConnectorName, String orgName, Context context) {
        PagedIterable<AzureDevOpsProjectInner> inner = this.serviceClient().list(resourceGroupName, securityConnectorName, orgName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AzureDevOpsProjectImpl((AzureDevOpsProjectInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<AzureDevOpsProject> getWithResponse(String resourceGroupName, String securityConnectorName, String orgName, String projectName, Context context) {
        Response<AzureDevOpsProjectInner> inner = this.serviceClient().getWithResponse(resourceGroupName, securityConnectorName, orgName, projectName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AzureDevOpsProjectImpl((AzureDevOpsProjectInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public AzureDevOpsProject get(String resourceGroupName, String securityConnectorName, String orgName, String projectName) {
        AzureDevOpsProjectInner inner = this.serviceClient().get(resourceGroupName, securityConnectorName, orgName, projectName);
        if (inner != null) {
            return new AzureDevOpsProjectImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public AzureDevOpsProject getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String securityConnectorName = ResourceManagerUtils.getValueFromIdByName(id, "securityConnectors");
        if (securityConnectorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'securityConnectors'.", id)));
        }
        String orgName = ResourceManagerUtils.getValueFromIdByName(id, "azureDevOpsOrgs");
        if (orgName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'azureDevOpsOrgs'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        return (AzureDevOpsProject)this.getWithResponse(resourceGroupName, securityConnectorName, orgName, projectName, Context.NONE).getValue();
    }

    @Override
    public Response<AzureDevOpsProject> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String securityConnectorName = ResourceManagerUtils.getValueFromIdByName(id, "securityConnectors");
        if (securityConnectorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'securityConnectors'.", id)));
        }
        String orgName = ResourceManagerUtils.getValueFromIdByName(id, "azureDevOpsOrgs");
        if (orgName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'azureDevOpsOrgs'.", id)));
        }
        String projectName = ResourceManagerUtils.getValueFromIdByName(id, "projects");
        if (projectName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'projects'.", id)));
        }
        return this.getWithResponse(resourceGroupName, securityConnectorName, orgName, projectName, context);
    }

    private AzureDevOpsProjectsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public AzureDevOpsProjectImpl define(String name) {
        return new AzureDevOpsProjectImpl(name, this.manager());
    }
}

