/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.models.AzureDevOpsRepositoryInner;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.AzureDevOpsRepository;
import com.azure.resourcemanager.security.models.AzureDevOpsRepositoryProperties;

public final class AzureDevOpsRepositoryImpl
implements AzureDevOpsRepository,
AzureDevOpsRepository.Definition,
AzureDevOpsRepository.Update {
    private AzureDevOpsRepositoryInner innerObject;
    private final SecurityManager serviceManager;
    private String resourceGroupName;
    private String securityConnectorName;
    private String orgName;
    private String projectName;
    private String repoName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public AzureDevOpsRepositoryProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public AzureDevOpsRepositoryInner innerModel() {
        return this.innerObject;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public AzureDevOpsRepositoryImpl withExistingProject(String resourceGroupName, String securityConnectorName, String orgName, String projectName) {
        this.resourceGroupName = resourceGroupName;
        this.securityConnectorName = securityConnectorName;
        this.orgName = orgName;
        this.projectName = projectName;
        return this;
    }

    @Override
    public AzureDevOpsRepository create() {
        this.innerObject = this.serviceManager.serviceClient().getAzureDevOpsRepos().createOrUpdate(this.resourceGroupName, this.securityConnectorName, this.orgName, this.projectName, this.repoName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public AzureDevOpsRepository create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAzureDevOpsRepos().createOrUpdate(this.resourceGroupName, this.securityConnectorName, this.orgName, this.projectName, this.repoName, this.innerModel(), context);
        return this;
    }

    AzureDevOpsRepositoryImpl(String name, SecurityManager serviceManager) {
        this.innerObject = new AzureDevOpsRepositoryInner();
        this.serviceManager = serviceManager;
        this.repoName = name;
    }

    @Override
    public AzureDevOpsRepositoryImpl update() {
        return this;
    }

    @Override
    public AzureDevOpsRepository apply() {
        this.innerObject = this.serviceManager.serviceClient().getAzureDevOpsRepos().update(this.resourceGroupName, this.securityConnectorName, this.orgName, this.projectName, this.repoName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public AzureDevOpsRepository apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAzureDevOpsRepos().update(this.resourceGroupName, this.securityConnectorName, this.orgName, this.projectName, this.repoName, this.innerModel(), context);
        return this;
    }

    AzureDevOpsRepositoryImpl(AzureDevOpsRepositoryInner innerObject, SecurityManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.securityConnectorName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "securityConnectors");
        this.orgName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "azureDevOpsOrgs");
        this.projectName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "projects");
        this.repoName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "repos");
    }

    @Override
    public AzureDevOpsRepository refresh() {
        this.innerObject = (AzureDevOpsRepositoryInner)((Object)this.serviceManager.serviceClient().getAzureDevOpsRepos().getWithResponse(this.resourceGroupName, this.securityConnectorName, this.orgName, this.projectName, this.repoName, Context.NONE).getValue());
        return this;
    }

    @Override
    public AzureDevOpsRepository refresh(Context context) {
        this.innerObject = (AzureDevOpsRepositoryInner)((Object)this.serviceManager.serviceClient().getAzureDevOpsRepos().getWithResponse(this.resourceGroupName, this.securityConnectorName, this.orgName, this.projectName, this.repoName, context).getValue());
        return this;
    }

    @Override
    public AzureDevOpsRepositoryImpl withProperties(AzureDevOpsRepositoryProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

