/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.ConnectorsClient;
import com.azure.resourcemanager.security.fluent.models.ConnectorSettingInner;
import com.azure.resourcemanager.security.implementation.ConnectorSettingImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.ConnectorSetting;
import com.azure.resourcemanager.security.models.Connectors;

public final class ConnectorsImpl
implements Connectors {
    private static final ClientLogger LOGGER = new ClientLogger(ConnectorsImpl.class);
    private final ConnectorsClient innerClient;
    private final SecurityManager serviceManager;

    public ConnectorsImpl(ConnectorsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ConnectorSetting> list() {
        PagedIterable<ConnectorSettingInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConnectorSettingImpl((ConnectorSettingInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ConnectorSetting> list(Context context) {
        PagedIterable<ConnectorSettingInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConnectorSettingImpl((ConnectorSettingInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ConnectorSetting> getWithResponse(String connectorName, Context context) {
        Response<ConnectorSettingInner> inner = this.serviceClient().getWithResponse(connectorName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ConnectorSettingImpl((ConnectorSettingInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ConnectorSetting get(String connectorName) {
        ConnectorSettingInner inner = this.serviceClient().get(connectorName);
        if (inner != null) {
            return new ConnectorSettingImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String connectorName, Context context) {
        return this.serviceClient().deleteWithResponse(connectorName, context);
    }

    @Override
    public void delete(String connectorName) {
        this.serviceClient().delete(connectorName);
    }

    @Override
    public ConnectorSetting getById(String id) {
        String connectorName = ResourceManagerUtils.getValueFromIdByName(id, "connectors");
        if (connectorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'connectors'.", id)));
        }
        return (ConnectorSetting)this.getWithResponse(connectorName, Context.NONE).getValue();
    }

    @Override
    public Response<ConnectorSetting> getByIdWithResponse(String id, Context context) {
        String connectorName = ResourceManagerUtils.getValueFromIdByName(id, "connectors");
        if (connectorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'connectors'.", id)));
        }
        return this.getWithResponse(connectorName, context);
    }

    @Override
    public void deleteById(String id) {
        String connectorName = ResourceManagerUtils.getValueFromIdByName(id, "connectors");
        if (connectorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'connectors'.", id)));
        }
        this.deleteWithResponse(connectorName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String connectorName = ResourceManagerUtils.getValueFromIdByName(id, "connectors");
        if (connectorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'connectors'.", id)));
        }
        return this.deleteWithResponse(connectorName, context);
    }

    private ConnectorsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public ConnectorSettingImpl define(String name) {
        return new ConnectorSettingImpl(name, this.manager());
    }
}

