/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.models.CustomAssessmentAutomationInner;
import com.azure.resourcemanager.security.models.CustomAssessmentAutomation;
import com.azure.resourcemanager.security.models.CustomAssessmentAutomationRequest;
import com.azure.resourcemanager.security.models.SeverityEnum;
import com.azure.resourcemanager.security.models.SupportedCloudEnum;

public final class CustomAssessmentAutomationImpl
implements CustomAssessmentAutomation,
CustomAssessmentAutomation.Definition {
    private CustomAssessmentAutomationInner innerObject;
    private final SecurityManager serviceManager;
    private String resourceGroupName;
    private String customAssessmentAutomationName;
    private CustomAssessmentAutomationRequest createCustomAssessmentAutomationBody;

    CustomAssessmentAutomationImpl(CustomAssessmentAutomationInner innerObject, SecurityManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String compressedQuery() {
        return this.innerModel().compressedQuery();
    }

    @Override
    public SupportedCloudEnum supportedCloud() {
        return this.innerModel().supportedCloud();
    }

    @Override
    public SeverityEnum severity() {
        return this.innerModel().severity();
    }

    @Override
    public String displayName() {
        return this.innerModel().displayName();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public String remediationDescription() {
        return this.innerModel().remediationDescription();
    }

    @Override
    public String assessmentKey() {
        return this.innerModel().assessmentKey();
    }

    @Override
    public CustomAssessmentAutomationInner innerModel() {
        return this.innerObject;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public CustomAssessmentAutomationImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public CustomAssessmentAutomation create() {
        this.innerObject = (CustomAssessmentAutomationInner)((Object)this.serviceManager.serviceClient().getCustomAssessmentAutomations().createWithResponse(this.resourceGroupName, this.customAssessmentAutomationName, this.createCustomAssessmentAutomationBody, Context.NONE).getValue());
        return this;
    }

    @Override
    public CustomAssessmentAutomation create(Context context) {
        this.innerObject = (CustomAssessmentAutomationInner)((Object)this.serviceManager.serviceClient().getCustomAssessmentAutomations().createWithResponse(this.resourceGroupName, this.customAssessmentAutomationName, this.createCustomAssessmentAutomationBody, context).getValue());
        return this;
    }

    CustomAssessmentAutomationImpl(String name, SecurityManager serviceManager) {
        this.innerObject = new CustomAssessmentAutomationInner();
        this.serviceManager = serviceManager;
        this.customAssessmentAutomationName = name;
        this.createCustomAssessmentAutomationBody = new CustomAssessmentAutomationRequest();
    }

    @Override
    public CustomAssessmentAutomation refresh() {
        this.innerObject = (CustomAssessmentAutomationInner)((Object)this.serviceManager.serviceClient().getCustomAssessmentAutomations().getByResourceGroupWithResponse(this.resourceGroupName, this.customAssessmentAutomationName, Context.NONE).getValue());
        return this;
    }

    @Override
    public CustomAssessmentAutomation refresh(Context context) {
        this.innerObject = (CustomAssessmentAutomationInner)((Object)this.serviceManager.serviceClient().getCustomAssessmentAutomations().getByResourceGroupWithResponse(this.resourceGroupName, this.customAssessmentAutomationName, context).getValue());
        return this;
    }

    @Override
    public CustomAssessmentAutomationImpl withCompressedQuery(String compressedQuery) {
        this.createCustomAssessmentAutomationBody.withCompressedQuery(compressedQuery);
        return this;
    }

    @Override
    public CustomAssessmentAutomationImpl withSupportedCloud(SupportedCloudEnum supportedCloud) {
        this.createCustomAssessmentAutomationBody.withSupportedCloud(supportedCloud);
        return this;
    }

    @Override
    public CustomAssessmentAutomationImpl withSeverity(SeverityEnum severity) {
        this.createCustomAssessmentAutomationBody.withSeverity(severity);
        return this;
    }

    @Override
    public CustomAssessmentAutomationImpl withDisplayName(String displayName) {
        this.createCustomAssessmentAutomationBody.withDisplayName(displayName);
        return this;
    }

    @Override
    public CustomAssessmentAutomationImpl withDescription(String description) {
        this.createCustomAssessmentAutomationBody.withDescription(description);
        return this;
    }

    @Override
    public CustomAssessmentAutomationImpl withRemediationDescription(String remediationDescription) {
        this.createCustomAssessmentAutomationBody.withRemediationDescription(remediationDescription);
        return this;
    }
}

