/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.CustomAssessmentAutomationsClient;
import com.azure.resourcemanager.security.fluent.models.CustomAssessmentAutomationInner;
import com.azure.resourcemanager.security.implementation.CustomAssessmentAutomationImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.CustomAssessmentAutomation;
import com.azure.resourcemanager.security.models.CustomAssessmentAutomations;

public final class CustomAssessmentAutomationsImpl
implements CustomAssessmentAutomations {
    private static final ClientLogger LOGGER = new ClientLogger(CustomAssessmentAutomationsImpl.class);
    private final CustomAssessmentAutomationsClient innerClient;
    private final SecurityManager serviceManager;

    public CustomAssessmentAutomationsImpl(CustomAssessmentAutomationsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<CustomAssessmentAutomation> getByResourceGroupWithResponse(String resourceGroupName, String customAssessmentAutomationName, Context context) {
        Response<CustomAssessmentAutomationInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, customAssessmentAutomationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CustomAssessmentAutomationImpl((CustomAssessmentAutomationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public CustomAssessmentAutomation getByResourceGroup(String resourceGroupName, String customAssessmentAutomationName) {
        CustomAssessmentAutomationInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, customAssessmentAutomationName);
        if (inner != null) {
            return new CustomAssessmentAutomationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteByResourceGroupWithResponse(String resourceGroupName, String customAssessmentAutomationName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, customAssessmentAutomationName, context);
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String customAssessmentAutomationName) {
        this.serviceClient().delete(resourceGroupName, customAssessmentAutomationName);
    }

    @Override
    public PagedIterable<CustomAssessmentAutomation> listByResourceGroup(String resourceGroupName) {
        PagedIterable<CustomAssessmentAutomationInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CustomAssessmentAutomationImpl((CustomAssessmentAutomationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<CustomAssessmentAutomation> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<CustomAssessmentAutomationInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CustomAssessmentAutomationImpl((CustomAssessmentAutomationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<CustomAssessmentAutomation> list() {
        PagedIterable<CustomAssessmentAutomationInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CustomAssessmentAutomationImpl((CustomAssessmentAutomationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<CustomAssessmentAutomation> list(Context context) {
        PagedIterable<CustomAssessmentAutomationInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CustomAssessmentAutomationImpl((CustomAssessmentAutomationInner)((Object)inner1), this.manager()));
    }

    @Override
    public CustomAssessmentAutomation getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourcegroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcegroups'.", id)));
        }
        String customAssessmentAutomationName = ResourceManagerUtils.getValueFromIdByName(id, "customAssessmentAutomations");
        if (customAssessmentAutomationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'customAssessmentAutomations'.", id)));
        }
        return (CustomAssessmentAutomation)this.getByResourceGroupWithResponse(resourceGroupName, customAssessmentAutomationName, Context.NONE).getValue();
    }

    @Override
    public Response<CustomAssessmentAutomation> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourcegroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcegroups'.", id)));
        }
        String customAssessmentAutomationName = ResourceManagerUtils.getValueFromIdByName(id, "customAssessmentAutomations");
        if (customAssessmentAutomationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'customAssessmentAutomations'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, customAssessmentAutomationName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourcegroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcegroups'.", id)));
        }
        String customAssessmentAutomationName = ResourceManagerUtils.getValueFromIdByName(id, "customAssessmentAutomations");
        if (customAssessmentAutomationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'customAssessmentAutomations'.", id)));
        }
        this.deleteByResourceGroupWithResponse(resourceGroupName, customAssessmentAutomationName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourcegroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourcegroups'.", id)));
        }
        String customAssessmentAutomationName = ResourceManagerUtils.getValueFromIdByName(id, "customAssessmentAutomations");
        if (customAssessmentAutomationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'customAssessmentAutomations'.", id)));
        }
        return this.deleteByResourceGroupWithResponse(resourceGroupName, customAssessmentAutomationName, context);
    }

    private CustomAssessmentAutomationsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public CustomAssessmentAutomationImpl define(String name) {
        return new CustomAssessmentAutomationImpl(name, this.manager());
    }
}

