/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.security.fluent.DefenderForStoragesClient;
import com.azure.resourcemanager.security.fluent.models.DefenderForStorageSettingInner;
import com.azure.resourcemanager.security.implementation.SecurityCenterImpl;
import com.azure.resourcemanager.security.models.SettingName;
import reactor.core.publisher.Mono;

public final class DefenderForStoragesClientImpl
implements DefenderForStoragesClient {
    private final DefenderForStoragesService service;
    private final SecurityCenterImpl client;

    DefenderForStoragesClientImpl(SecurityCenterImpl client) {
        this.service = (DefenderForStoragesService)RestProxy.create(DefenderForStoragesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DefenderForStorageSettingInner>> getWithResponseAsync(String resourceId, SettingName settingName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (settingName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter settingName is required and cannot be null."));
        }
        String apiVersion = "2022-12-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2022-12-01-preview", resourceId, settingName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DefenderForStorageSettingInner>> getWithResponseAsync(String resourceId, SettingName settingName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (settingName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter settingName is required and cannot be null."));
        }
        String apiVersion = "2022-12-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), "2022-12-01-preview", resourceId, settingName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DefenderForStorageSettingInner> getAsync(String resourceId, SettingName settingName) {
        return this.getWithResponseAsync(resourceId, settingName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DefenderForStorageSettingInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DefenderForStorageSettingInner> getWithResponse(String resourceId, SettingName settingName, Context context) {
        return (Response)this.getWithResponseAsync(resourceId, settingName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DefenderForStorageSettingInner get(String resourceId, SettingName settingName) {
        return (DefenderForStorageSettingInner)((Object)this.getWithResponse(resourceId, settingName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DefenderForStorageSettingInner>> createWithResponseAsync(String resourceId, SettingName settingName, DefenderForStorageSettingInner defenderForStorageSetting) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (settingName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter settingName is required and cannot be null."));
        }
        if (defenderForStorageSetting == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter defenderForStorageSetting is required and cannot be null."));
        }
        defenderForStorageSetting.validate();
        String apiVersion = "2022-12-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), "2022-12-01-preview", resourceId, settingName, defenderForStorageSetting, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DefenderForStorageSettingInner>> createWithResponseAsync(String resourceId, SettingName settingName, DefenderForStorageSettingInner defenderForStorageSetting, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (settingName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter settingName is required and cannot be null."));
        }
        if (defenderForStorageSetting == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter defenderForStorageSetting is required and cannot be null."));
        }
        defenderForStorageSetting.validate();
        String apiVersion = "2022-12-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), "2022-12-01-preview", resourceId, settingName, defenderForStorageSetting, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DefenderForStorageSettingInner> createAsync(String resourceId, SettingName settingName, DefenderForStorageSettingInner defenderForStorageSetting) {
        return this.createWithResponseAsync(resourceId, settingName, defenderForStorageSetting).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DefenderForStorageSettingInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DefenderForStorageSettingInner> createWithResponse(String resourceId, SettingName settingName, DefenderForStorageSettingInner defenderForStorageSetting, Context context) {
        return (Response)this.createWithResponseAsync(resourceId, settingName, defenderForStorageSetting, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DefenderForStorageSettingInner create(String resourceId, SettingName settingName, DefenderForStorageSettingInner defenderForStorageSetting) {
        return (DefenderForStorageSettingInner)((Object)this.createWithResponse(resourceId, settingName, defenderForStorageSetting, Context.NONE).getValue());
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SecurityCenterDefend")
    public static interface DefenderForStoragesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceId}/providers/Microsoft.Security/defenderForStorageSettings/{settingName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DefenderForStorageSettingInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="resourceId", encoded=true) String var3, @PathParam(value="settingName") SettingName var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/{resourceId}/providers/Microsoft.Security/defenderForStorageSettings/{settingName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DefenderForStorageSettingInner>> create(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="resourceId", encoded=true) String var3, @PathParam(value="settingName") SettingName var4, @BodyParam(value="application/json") DefenderForStorageSettingInner var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

