/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.DefenderForStoragesClient;
import com.azure.resourcemanager.security.fluent.models.DefenderForStorageSettingInner;
import com.azure.resourcemanager.security.implementation.DefenderForStorageSettingImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.DefenderForStorageSetting;
import com.azure.resourcemanager.security.models.DefenderForStorages;
import com.azure.resourcemanager.security.models.SettingName;

public final class DefenderForStoragesImpl
implements DefenderForStorages {
    private static final ClientLogger LOGGER = new ClientLogger(DefenderForStoragesImpl.class);
    private final DefenderForStoragesClient innerClient;
    private final SecurityManager serviceManager;

    public DefenderForStoragesImpl(DefenderForStoragesClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<DefenderForStorageSetting> getWithResponse(String resourceId, SettingName settingName, Context context) {
        Response<DefenderForStorageSettingInner> inner = this.serviceClient().getWithResponse(resourceId, settingName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DefenderForStorageSettingImpl((DefenderForStorageSettingInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DefenderForStorageSetting get(String resourceId, SettingName settingName) {
        DefenderForStorageSettingInner inner = this.serviceClient().get(resourceId, settingName);
        if (inner != null) {
            return new DefenderForStorageSettingImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public DefenderForStorageSetting getById(String id) {
        String resourceId = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceId}/providers/Microsoft.Security/defenderForStorageSettings/{settingName}", "resourceId");
        if (resourceId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceId'.", id)));
        }
        String settingNameLocal = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceId}/providers/Microsoft.Security/defenderForStorageSettings/{settingName}", "settingName");
        if (settingNameLocal == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'defenderForStorageSettings'.", id)));
        }
        SettingName settingName = SettingName.fromString(settingNameLocal);
        return (DefenderForStorageSetting)this.getWithResponse(resourceId, settingName, Context.NONE).getValue();
    }

    @Override
    public Response<DefenderForStorageSetting> getByIdWithResponse(String id, Context context) {
        String resourceId = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceId}/providers/Microsoft.Security/defenderForStorageSettings/{settingName}", "resourceId");
        if (resourceId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceId'.", id)));
        }
        String settingNameLocal = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceId}/providers/Microsoft.Security/defenderForStorageSettings/{settingName}", "settingName");
        if (settingNameLocal == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'defenderForStorageSettings'.", id)));
        }
        SettingName settingName = SettingName.fromString(settingNameLocal);
        return this.getWithResponse(resourceId, settingName, context);
    }

    private DefenderForStoragesClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public DefenderForStorageSettingImpl define(SettingName name) {
        return new DefenderForStorageSettingImpl(name, this.manager());
    }
}

