/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.DeviceSecurityGroupsClient;
import com.azure.resourcemanager.security.fluent.models.DeviceSecurityGroupInner;
import com.azure.resourcemanager.security.implementation.DeviceSecurityGroupImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.DeviceSecurityGroup;
import com.azure.resourcemanager.security.models.DeviceSecurityGroups;

public final class DeviceSecurityGroupsImpl
implements DeviceSecurityGroups {
    private static final ClientLogger LOGGER = new ClientLogger(DeviceSecurityGroupsImpl.class);
    private final DeviceSecurityGroupsClient innerClient;
    private final SecurityManager serviceManager;

    public DeviceSecurityGroupsImpl(DeviceSecurityGroupsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<DeviceSecurityGroup> list(String resourceId) {
        PagedIterable<DeviceSecurityGroupInner> inner = this.serviceClient().list(resourceId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DeviceSecurityGroupImpl((DeviceSecurityGroupInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DeviceSecurityGroup> list(String resourceId, Context context) {
        PagedIterable<DeviceSecurityGroupInner> inner = this.serviceClient().list(resourceId, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DeviceSecurityGroupImpl((DeviceSecurityGroupInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<DeviceSecurityGroup> getWithResponse(String resourceId, String deviceSecurityGroupName, Context context) {
        Response<DeviceSecurityGroupInner> inner = this.serviceClient().getWithResponse(resourceId, deviceSecurityGroupName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DeviceSecurityGroupImpl((DeviceSecurityGroupInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DeviceSecurityGroup get(String resourceId, String deviceSecurityGroupName) {
        DeviceSecurityGroupInner inner = this.serviceClient().get(resourceId, deviceSecurityGroupName);
        if (inner != null) {
            return new DeviceSecurityGroupImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteByResourceGroupWithResponse(String resourceId, String deviceSecurityGroupName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceId, deviceSecurityGroupName, context);
    }

    @Override
    public void deleteByResourceGroup(String resourceId, String deviceSecurityGroupName) {
        this.serviceClient().delete(resourceId, deviceSecurityGroupName);
    }

    @Override
    public DeviceSecurityGroup getById(String id) {
        String resourceId = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceId}/providers/Microsoft.Security/deviceSecurityGroups/{deviceSecurityGroupName}", "resourceId");
        if (resourceId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceId'.", id)));
        }
        String deviceSecurityGroupName = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceId}/providers/Microsoft.Security/deviceSecurityGroups/{deviceSecurityGroupName}", "deviceSecurityGroupName");
        if (deviceSecurityGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'deviceSecurityGroups'.", id)));
        }
        return (DeviceSecurityGroup)this.getWithResponse(resourceId, deviceSecurityGroupName, Context.NONE).getValue();
    }

    @Override
    public Response<DeviceSecurityGroup> getByIdWithResponse(String id, Context context) {
        String resourceId = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceId}/providers/Microsoft.Security/deviceSecurityGroups/{deviceSecurityGroupName}", "resourceId");
        if (resourceId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceId'.", id)));
        }
        String deviceSecurityGroupName = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceId}/providers/Microsoft.Security/deviceSecurityGroups/{deviceSecurityGroupName}", "deviceSecurityGroupName");
        if (deviceSecurityGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'deviceSecurityGroups'.", id)));
        }
        return this.getWithResponse(resourceId, deviceSecurityGroupName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceId = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceId}/providers/Microsoft.Security/deviceSecurityGroups/{deviceSecurityGroupName}", "resourceId");
        if (resourceId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceId'.", id)));
        }
        String deviceSecurityGroupName = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceId}/providers/Microsoft.Security/deviceSecurityGroups/{deviceSecurityGroupName}", "deviceSecurityGroupName");
        if (deviceSecurityGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'deviceSecurityGroups'.", id)));
        }
        this.deleteByResourceGroupWithResponse(resourceId, deviceSecurityGroupName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceId = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceId}/providers/Microsoft.Security/deviceSecurityGroups/{deviceSecurityGroupName}", "resourceId");
        if (resourceId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceId'.", id)));
        }
        String deviceSecurityGroupName = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceId}/providers/Microsoft.Security/deviceSecurityGroups/{deviceSecurityGroupName}", "deviceSecurityGroupName");
        if (deviceSecurityGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'deviceSecurityGroups'.", id)));
        }
        return this.deleteByResourceGroupWithResponse(resourceId, deviceSecurityGroupName, context);
    }

    private DeviceSecurityGroupsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public DeviceSecurityGroupImpl define(String name) {
        return new DeviceSecurityGroupImpl(name, this.manager());
    }
}

