/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.ExternalSecuritySolutionsClient;
import com.azure.resourcemanager.security.fluent.models.ExternalSecuritySolutionInner;
import com.azure.resourcemanager.security.implementation.ExternalSecuritySolutionImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.ExternalSecuritySolution;
import com.azure.resourcemanager.security.models.ExternalSecuritySolutions;

public final class ExternalSecuritySolutionsImpl
implements ExternalSecuritySolutions {
    private static final ClientLogger LOGGER = new ClientLogger(ExternalSecuritySolutionsImpl.class);
    private final ExternalSecuritySolutionsClient innerClient;
    private final SecurityManager serviceManager;

    public ExternalSecuritySolutionsImpl(ExternalSecuritySolutionsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ExternalSecuritySolution> list() {
        PagedIterable<ExternalSecuritySolutionInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ExternalSecuritySolutionImpl((ExternalSecuritySolutionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ExternalSecuritySolution> list(Context context) {
        PagedIterable<ExternalSecuritySolutionInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ExternalSecuritySolutionImpl((ExternalSecuritySolutionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ExternalSecuritySolution> listByHomeRegion(String ascLocation) {
        PagedIterable<ExternalSecuritySolutionInner> inner = this.serviceClient().listByHomeRegion(ascLocation);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ExternalSecuritySolutionImpl((ExternalSecuritySolutionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ExternalSecuritySolution> listByHomeRegion(String ascLocation, Context context) {
        PagedIterable<ExternalSecuritySolutionInner> inner = this.serviceClient().listByHomeRegion(ascLocation, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ExternalSecuritySolutionImpl((ExternalSecuritySolutionInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ExternalSecuritySolution> getWithResponse(String resourceGroupName, String ascLocation, String externalSecuritySolutionsName, Context context) {
        Response<ExternalSecuritySolutionInner> inner = this.serviceClient().getWithResponse(resourceGroupName, ascLocation, externalSecuritySolutionsName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ExternalSecuritySolutionImpl((ExternalSecuritySolutionInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ExternalSecuritySolution get(String resourceGroupName, String ascLocation, String externalSecuritySolutionsName) {
        ExternalSecuritySolutionInner inner = this.serviceClient().get(resourceGroupName, ascLocation, externalSecuritySolutionsName);
        if (inner != null) {
            return new ExternalSecuritySolutionImpl(inner, this.manager());
        }
        return null;
    }

    private ExternalSecuritySolutionsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

