/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.GitHubOwnersClient;
import com.azure.resourcemanager.security.fluent.models.GitHubOwnerInner;
import com.azure.resourcemanager.security.fluent.models.GitHubOwnerListResponseInner;
import com.azure.resourcemanager.security.implementation.GitHubOwnerImpl;
import com.azure.resourcemanager.security.implementation.GitHubOwnerListResponseImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.GitHubOwner;
import com.azure.resourcemanager.security.models.GitHubOwnerListResponse;
import com.azure.resourcemanager.security.models.GitHubOwners;

public final class GitHubOwnersImpl
implements GitHubOwners {
    private static final ClientLogger LOGGER = new ClientLogger(GitHubOwnersImpl.class);
    private final GitHubOwnersClient innerClient;
    private final SecurityManager serviceManager;

    public GitHubOwnersImpl(GitHubOwnersClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<GitHubOwnerListResponse> listAvailableWithResponse(String resourceGroupName, String securityConnectorName, Context context) {
        Response<GitHubOwnerListResponseInner> inner = this.serviceClient().listAvailableWithResponse(resourceGroupName, securityConnectorName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new GitHubOwnerListResponseImpl((GitHubOwnerListResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public GitHubOwnerListResponse listAvailable(String resourceGroupName, String securityConnectorName) {
        GitHubOwnerListResponseInner inner = this.serviceClient().listAvailable(resourceGroupName, securityConnectorName);
        if (inner != null) {
            return new GitHubOwnerListResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<GitHubOwner> list(String resourceGroupName, String securityConnectorName) {
        PagedIterable<GitHubOwnerInner> inner = this.serviceClient().list(resourceGroupName, securityConnectorName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GitHubOwnerImpl((GitHubOwnerInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<GitHubOwner> list(String resourceGroupName, String securityConnectorName, Context context) {
        PagedIterable<GitHubOwnerInner> inner = this.serviceClient().list(resourceGroupName, securityConnectorName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GitHubOwnerImpl((GitHubOwnerInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<GitHubOwner> getWithResponse(String resourceGroupName, String securityConnectorName, String ownerName, Context context) {
        Response<GitHubOwnerInner> inner = this.serviceClient().getWithResponse(resourceGroupName, securityConnectorName, ownerName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new GitHubOwnerImpl((GitHubOwnerInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public GitHubOwner get(String resourceGroupName, String securityConnectorName, String ownerName) {
        GitHubOwnerInner inner = this.serviceClient().get(resourceGroupName, securityConnectorName, ownerName);
        if (inner != null) {
            return new GitHubOwnerImpl(inner, this.manager());
        }
        return null;
    }

    private GitHubOwnersClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

