/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.security.fluent.GitHubReposClient;
import com.azure.resourcemanager.security.fluent.models.GitHubRepositoryInner;
import com.azure.resourcemanager.security.implementation.SecurityCenterImpl;
import com.azure.resourcemanager.security.models.GitHubRepositoryListResponse;
import reactor.core.publisher.Mono;

public final class GitHubReposClientImpl
implements GitHubReposClient {
    private final GitHubReposService service;
    private final SecurityCenterImpl client;

    GitHubReposClientImpl(SecurityCenterImpl client) {
        this.service = (GitHubReposService)RestProxy.create(GitHubReposService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GitHubRepositoryInner>> listSinglePageAsync(String resourceGroupName, String securityConnectorName, String ownerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (securityConnectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityConnectorName is required and cannot be null."));
        }
        if (ownerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ownerName is required and cannot be null."));
        }
        String apiVersion = "2023-09-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, securityConnectorName, ownerName, "2023-09-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GitHubRepositoryListResponse)res.getValue()).value(), ((GitHubRepositoryListResponse)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GitHubRepositoryInner>> listSinglePageAsync(String resourceGroupName, String securityConnectorName, String ownerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (securityConnectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityConnectorName is required and cannot be null."));
        }
        if (ownerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ownerName is required and cannot be null."));
        }
        String apiVersion = "2023-09-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, securityConnectorName, ownerName, "2023-09-01-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GitHubRepositoryListResponse)res.getValue()).value(), ((GitHubRepositoryListResponse)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<GitHubRepositoryInner> listAsync(String resourceGroupName, String securityConnectorName, String ownerName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, securityConnectorName, ownerName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<GitHubRepositoryInner> listAsync(String resourceGroupName, String securityConnectorName, String ownerName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, securityConnectorName, ownerName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<GitHubRepositoryInner> list(String resourceGroupName, String securityConnectorName, String ownerName) {
        return new PagedIterable(this.listAsync(resourceGroupName, securityConnectorName, ownerName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<GitHubRepositoryInner> list(String resourceGroupName, String securityConnectorName, String ownerName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, securityConnectorName, ownerName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GitHubRepositoryInner>> getWithResponseAsync(String resourceGroupName, String securityConnectorName, String ownerName, String repoName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (securityConnectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityConnectorName is required and cannot be null."));
        }
        if (ownerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ownerName is required and cannot be null."));
        }
        if (repoName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter repoName is required and cannot be null."));
        }
        String apiVersion = "2023-09-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, securityConnectorName, ownerName, repoName, "2023-09-01-preview", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GitHubRepositoryInner>> getWithResponseAsync(String resourceGroupName, String securityConnectorName, String ownerName, String repoName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (securityConnectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityConnectorName is required and cannot be null."));
        }
        if (ownerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ownerName is required and cannot be null."));
        }
        if (repoName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter repoName is required and cannot be null."));
        }
        String apiVersion = "2023-09-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, securityConnectorName, ownerName, repoName, "2023-09-01-preview", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GitHubRepositoryInner> getAsync(String resourceGroupName, String securityConnectorName, String ownerName, String repoName) {
        return this.getWithResponseAsync(resourceGroupName, securityConnectorName, ownerName, repoName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((GitHubRepositoryInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<GitHubRepositoryInner> getWithResponse(String resourceGroupName, String securityConnectorName, String ownerName, String repoName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, securityConnectorName, ownerName, repoName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GitHubRepositoryInner get(String resourceGroupName, String securityConnectorName, String ownerName, String repoName) {
        return (GitHubRepositoryInner)((Object)this.getWithResponse(resourceGroupName, securityConnectorName, ownerName, repoName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GitHubRepositoryInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GitHubRepositoryListResponse)res.getValue()).value(), ((GitHubRepositoryListResponse)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GitHubRepositoryInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GitHubRepositoryListResponse)res.getValue()).value(), ((GitHubRepositoryListResponse)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SecurityCenterGitHub")
    public static interface GitHubReposService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/gitHubOwners/{ownerName}/repos")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GitHubRepositoryListResponse>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="securityConnectorName") String var4, @PathParam(value="ownerName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/gitHubOwners/{ownerName}/repos/{repoName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GitHubRepositoryInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="securityConnectorName") String var4, @PathParam(value="ownerName") String var5, @PathParam(value="repoName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GitHubRepositoryListResponse>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

