/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.security.fluent.GitLabGroupsClient;
import com.azure.resourcemanager.security.fluent.models.GitLabGroupInner;
import com.azure.resourcemanager.security.fluent.models.GitLabGroupListResponseInner;
import com.azure.resourcemanager.security.implementation.SecurityCenterImpl;
import reactor.core.publisher.Mono;

public final class GitLabGroupsClientImpl
implements GitLabGroupsClient {
    private final GitLabGroupsService service;
    private final SecurityCenterImpl client;

    GitLabGroupsClientImpl(SecurityCenterImpl client) {
        this.service = (GitLabGroupsService)RestProxy.create(GitLabGroupsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GitLabGroupListResponseInner>> listAvailableWithResponseAsync(String resourceGroupName, String securityConnectorName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (securityConnectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityConnectorName is required and cannot be null."));
        }
        String apiVersion = "2023-09-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAvailable(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, securityConnectorName, "2023-09-01-preview", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GitLabGroupListResponseInner>> listAvailableWithResponseAsync(String resourceGroupName, String securityConnectorName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (securityConnectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityConnectorName is required and cannot be null."));
        }
        String apiVersion = "2023-09-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listAvailable(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, securityConnectorName, "2023-09-01-preview", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GitLabGroupListResponseInner> listAvailableAsync(String resourceGroupName, String securityConnectorName) {
        return this.listAvailableWithResponseAsync(resourceGroupName, securityConnectorName).flatMap(res -> Mono.justOrEmpty((Object)((GitLabGroupListResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<GitLabGroupListResponseInner> listAvailableWithResponse(String resourceGroupName, String securityConnectorName, Context context) {
        return (Response)this.listAvailableWithResponseAsync(resourceGroupName, securityConnectorName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GitLabGroupListResponseInner listAvailable(String resourceGroupName, String securityConnectorName) {
        return (GitLabGroupListResponseInner)this.listAvailableWithResponse(resourceGroupName, securityConnectorName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GitLabGroupInner>> listSinglePageAsync(String resourceGroupName, String securityConnectorName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (securityConnectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityConnectorName is required and cannot be null."));
        }
        String apiVersion = "2023-09-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, securityConnectorName, "2023-09-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GitLabGroupListResponseInner)res.getValue()).value(), ((GitLabGroupListResponseInner)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GitLabGroupInner>> listSinglePageAsync(String resourceGroupName, String securityConnectorName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (securityConnectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityConnectorName is required and cannot be null."));
        }
        String apiVersion = "2023-09-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, securityConnectorName, "2023-09-01-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GitLabGroupListResponseInner)res.getValue()).value(), ((GitLabGroupListResponseInner)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<GitLabGroupInner> listAsync(String resourceGroupName, String securityConnectorName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, securityConnectorName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<GitLabGroupInner> listAsync(String resourceGroupName, String securityConnectorName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, securityConnectorName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<GitLabGroupInner> list(String resourceGroupName, String securityConnectorName) {
        return new PagedIterable(this.listAsync(resourceGroupName, securityConnectorName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<GitLabGroupInner> list(String resourceGroupName, String securityConnectorName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, securityConnectorName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GitLabGroupInner>> getWithResponseAsync(String resourceGroupName, String securityConnectorName, String groupFQName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (securityConnectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityConnectorName is required and cannot be null."));
        }
        if (groupFQName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupFQName is required and cannot be null."));
        }
        String apiVersion = "2023-09-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, securityConnectorName, groupFQName, "2023-09-01-preview", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GitLabGroupInner>> getWithResponseAsync(String resourceGroupName, String securityConnectorName, String groupFQName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (securityConnectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityConnectorName is required and cannot be null."));
        }
        if (groupFQName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupFQName is required and cannot be null."));
        }
        String apiVersion = "2023-09-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, securityConnectorName, groupFQName, "2023-09-01-preview", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GitLabGroupInner> getAsync(String resourceGroupName, String securityConnectorName, String groupFQName) {
        return this.getWithResponseAsync(resourceGroupName, securityConnectorName, groupFQName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((GitLabGroupInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<GitLabGroupInner> getWithResponse(String resourceGroupName, String securityConnectorName, String groupFQName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, securityConnectorName, groupFQName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GitLabGroupInner get(String resourceGroupName, String securityConnectorName, String groupFQName) {
        return (GitLabGroupInner)((Object)this.getWithResponse(resourceGroupName, securityConnectorName, groupFQName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GitLabGroupInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GitLabGroupListResponseInner)res.getValue()).value(), ((GitLabGroupListResponseInner)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GitLabGroupInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GitLabGroupListResponseInner)res.getValue()).value(), ((GitLabGroupListResponseInner)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SecurityCenterGitLab")
    public static interface GitLabGroupsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/listAvailableGitLabGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GitLabGroupListResponseInner>> listAvailable(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="securityConnectorName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/gitLabGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GitLabGroupListResponseInner>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="securityConnectorName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/gitLabGroups/{groupFQName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GitLabGroupInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="securityConnectorName") String var4, @PathParam(value="groupFQName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GitLabGroupListResponseInner>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

