/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.GitLabGroupsClient;
import com.azure.resourcemanager.security.fluent.models.GitLabGroupInner;
import com.azure.resourcemanager.security.fluent.models.GitLabGroupListResponseInner;
import com.azure.resourcemanager.security.implementation.GitLabGroupImpl;
import com.azure.resourcemanager.security.implementation.GitLabGroupListResponseImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.GitLabGroup;
import com.azure.resourcemanager.security.models.GitLabGroupListResponse;
import com.azure.resourcemanager.security.models.GitLabGroups;

public final class GitLabGroupsImpl
implements GitLabGroups {
    private static final ClientLogger LOGGER = new ClientLogger(GitLabGroupsImpl.class);
    private final GitLabGroupsClient innerClient;
    private final SecurityManager serviceManager;

    public GitLabGroupsImpl(GitLabGroupsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<GitLabGroupListResponse> listAvailableWithResponse(String resourceGroupName, String securityConnectorName, Context context) {
        Response<GitLabGroupListResponseInner> inner = this.serviceClient().listAvailableWithResponse(resourceGroupName, securityConnectorName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new GitLabGroupListResponseImpl((GitLabGroupListResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public GitLabGroupListResponse listAvailable(String resourceGroupName, String securityConnectorName) {
        GitLabGroupListResponseInner inner = this.serviceClient().listAvailable(resourceGroupName, securityConnectorName);
        if (inner != null) {
            return new GitLabGroupListResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<GitLabGroup> list(String resourceGroupName, String securityConnectorName) {
        PagedIterable<GitLabGroupInner> inner = this.serviceClient().list(resourceGroupName, securityConnectorName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GitLabGroupImpl((GitLabGroupInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<GitLabGroup> list(String resourceGroupName, String securityConnectorName, Context context) {
        PagedIterable<GitLabGroupInner> inner = this.serviceClient().list(resourceGroupName, securityConnectorName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GitLabGroupImpl((GitLabGroupInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<GitLabGroup> getWithResponse(String resourceGroupName, String securityConnectorName, String groupFQName, Context context) {
        Response<GitLabGroupInner> inner = this.serviceClient().getWithResponse(resourceGroupName, securityConnectorName, groupFQName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new GitLabGroupImpl((GitLabGroupInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public GitLabGroup get(String resourceGroupName, String securityConnectorName, String groupFQName) {
        GitLabGroupInner inner = this.serviceClient().get(resourceGroupName, securityConnectorName, groupFQName);
        if (inner != null) {
            return new GitLabGroupImpl(inner, this.manager());
        }
        return null;
    }

    private GitLabGroupsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

