/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.security.fluent.GitLabProjectsClient;
import com.azure.resourcemanager.security.fluent.models.GitLabProjectInner;
import com.azure.resourcemanager.security.implementation.SecurityCenterImpl;
import com.azure.resourcemanager.security.models.GitLabProjectListResponse;
import reactor.core.publisher.Mono;

public final class GitLabProjectsClientImpl
implements GitLabProjectsClient {
    private final GitLabProjectsService service;
    private final SecurityCenterImpl client;

    GitLabProjectsClientImpl(SecurityCenterImpl client) {
        this.service = (GitLabProjectsService)RestProxy.create(GitLabProjectsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GitLabProjectInner>> listSinglePageAsync(String resourceGroupName, String securityConnectorName, String groupFQName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (securityConnectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityConnectorName is required and cannot be null."));
        }
        if (groupFQName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupFQName is required and cannot be null."));
        }
        String apiVersion = "2023-09-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, securityConnectorName, groupFQName, "2023-09-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GitLabProjectListResponse)res.getValue()).value(), ((GitLabProjectListResponse)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GitLabProjectInner>> listSinglePageAsync(String resourceGroupName, String securityConnectorName, String groupFQName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (securityConnectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityConnectorName is required and cannot be null."));
        }
        if (groupFQName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupFQName is required and cannot be null."));
        }
        String apiVersion = "2023-09-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, securityConnectorName, groupFQName, "2023-09-01-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GitLabProjectListResponse)res.getValue()).value(), ((GitLabProjectListResponse)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<GitLabProjectInner> listAsync(String resourceGroupName, String securityConnectorName, String groupFQName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, securityConnectorName, groupFQName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<GitLabProjectInner> listAsync(String resourceGroupName, String securityConnectorName, String groupFQName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, securityConnectorName, groupFQName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<GitLabProjectInner> list(String resourceGroupName, String securityConnectorName, String groupFQName) {
        return new PagedIterable(this.listAsync(resourceGroupName, securityConnectorName, groupFQName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<GitLabProjectInner> list(String resourceGroupName, String securityConnectorName, String groupFQName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, securityConnectorName, groupFQName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GitLabProjectInner>> getWithResponseAsync(String resourceGroupName, String securityConnectorName, String groupFQName, String projectName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (securityConnectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityConnectorName is required and cannot be null."));
        }
        if (groupFQName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupFQName is required and cannot be null."));
        }
        if (projectName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        String apiVersion = "2023-09-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, securityConnectorName, groupFQName, projectName, "2023-09-01-preview", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GitLabProjectInner>> getWithResponseAsync(String resourceGroupName, String securityConnectorName, String groupFQName, String projectName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (securityConnectorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityConnectorName is required and cannot be null."));
        }
        if (groupFQName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupFQName is required and cannot be null."));
        }
        if (projectName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter projectName is required and cannot be null."));
        }
        String apiVersion = "2023-09-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, securityConnectorName, groupFQName, projectName, "2023-09-01-preview", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GitLabProjectInner> getAsync(String resourceGroupName, String securityConnectorName, String groupFQName, String projectName) {
        return this.getWithResponseAsync(resourceGroupName, securityConnectorName, groupFQName, projectName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((GitLabProjectInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<GitLabProjectInner> getWithResponse(String resourceGroupName, String securityConnectorName, String groupFQName, String projectName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, securityConnectorName, groupFQName, projectName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GitLabProjectInner get(String resourceGroupName, String securityConnectorName, String groupFQName, String projectName) {
        return (GitLabProjectInner)((Object)this.getWithResponse(resourceGroupName, securityConnectorName, groupFQName, projectName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GitLabProjectInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GitLabProjectListResponse)res.getValue()).value(), ((GitLabProjectListResponse)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GitLabProjectInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GitLabProjectListResponse)res.getValue()).value(), ((GitLabProjectListResponse)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SecurityCenterGitLab")
    public static interface GitLabProjectsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/gitLabGroups/{groupFQName}/projects")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GitLabProjectListResponse>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="securityConnectorName") String var4, @PathParam(value="groupFQName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/gitLabGroups/{groupFQName}/projects/{projectName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GitLabProjectInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="securityConnectorName") String var4, @PathParam(value="groupFQName") String var5, @PathParam(value="projectName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GitLabProjectListResponse>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

