/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.GitLabProjectsClient;
import com.azure.resourcemanager.security.fluent.models.GitLabProjectInner;
import com.azure.resourcemanager.security.implementation.GitLabProjectImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.GitLabProject;
import com.azure.resourcemanager.security.models.GitLabProjects;

public final class GitLabProjectsImpl
implements GitLabProjects {
    private static final ClientLogger LOGGER = new ClientLogger(GitLabProjectsImpl.class);
    private final GitLabProjectsClient innerClient;
    private final SecurityManager serviceManager;

    public GitLabProjectsImpl(GitLabProjectsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<GitLabProject> list(String resourceGroupName, String securityConnectorName, String groupFQName) {
        PagedIterable<GitLabProjectInner> inner = this.serviceClient().list(resourceGroupName, securityConnectorName, groupFQName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GitLabProjectImpl((GitLabProjectInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<GitLabProject> list(String resourceGroupName, String securityConnectorName, String groupFQName, Context context) {
        PagedIterable<GitLabProjectInner> inner = this.serviceClient().list(resourceGroupName, securityConnectorName, groupFQName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GitLabProjectImpl((GitLabProjectInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<GitLabProject> getWithResponse(String resourceGroupName, String securityConnectorName, String groupFQName, String projectName, Context context) {
        Response<GitLabProjectInner> inner = this.serviceClient().getWithResponse(resourceGroupName, securityConnectorName, groupFQName, projectName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new GitLabProjectImpl((GitLabProjectInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public GitLabProject get(String resourceGroupName, String securityConnectorName, String groupFQName, String projectName) {
        GitLabProjectInner inner = this.serviceClient().get(resourceGroupName, securityConnectorName, groupFQName, projectName);
        if (inner != null) {
            return new GitLabProjectImpl(inner, this.manager());
        }
        return null;
    }

    private GitLabProjectsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

