/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.GitLabSubgroupsClient;
import com.azure.resourcemanager.security.fluent.models.GitLabGroupListResponseInner;
import com.azure.resourcemanager.security.implementation.GitLabGroupListResponseImpl;
import com.azure.resourcemanager.security.models.GitLabGroupListResponse;
import com.azure.resourcemanager.security.models.GitLabSubgroups;

public final class GitLabSubgroupsImpl
implements GitLabSubgroups {
    private static final ClientLogger LOGGER = new ClientLogger(GitLabSubgroupsImpl.class);
    private final GitLabSubgroupsClient innerClient;
    private final SecurityManager serviceManager;

    public GitLabSubgroupsImpl(GitLabSubgroupsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<GitLabGroupListResponse> listWithResponse(String resourceGroupName, String securityConnectorName, String groupFQName, Context context) {
        Response<GitLabGroupListResponseInner> inner = this.serviceClient().listWithResponse(resourceGroupName, securityConnectorName, groupFQName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new GitLabGroupListResponseImpl((GitLabGroupListResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public GitLabGroupListResponse list(String resourceGroupName, String securityConnectorName, String groupFQName) {
        GitLabGroupListResponseInner inner = this.serviceClient().list(resourceGroupName, securityConnectorName, groupFQName);
        if (inner != null) {
            return new GitLabGroupListResponseImpl(inner, this.manager());
        }
        return null;
    }

    private GitLabSubgroupsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

