/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.security.fluent.GovernanceAssignmentsClient;
import com.azure.resourcemanager.security.fluent.models.GovernanceAssignmentInner;
import com.azure.resourcemanager.security.implementation.SecurityCenterImpl;
import com.azure.resourcemanager.security.models.GovernanceAssignmentsList;
import reactor.core.publisher.Mono;

public final class GovernanceAssignmentsClientImpl
implements GovernanceAssignmentsClient {
    private final GovernanceAssignmentsService service;
    private final SecurityCenterImpl client;

    GovernanceAssignmentsClientImpl(SecurityCenterImpl client) {
        this.service = (GovernanceAssignmentsService)RestProxy.create(GovernanceAssignmentsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GovernanceAssignmentInner>> listSinglePageAsync(String scope, String assessmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (assessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter assessmentName is required and cannot be null."));
        }
        String apiVersion = "2022-01-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2022-01-01-preview", scope, assessmentName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GovernanceAssignmentsList)res.getValue()).value(), ((GovernanceAssignmentsList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GovernanceAssignmentInner>> listSinglePageAsync(String scope, String assessmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (assessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter assessmentName is required and cannot be null."));
        }
        String apiVersion = "2022-01-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2022-01-01-preview", scope, assessmentName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GovernanceAssignmentsList)res.getValue()).value(), ((GovernanceAssignmentsList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<GovernanceAssignmentInner> listAsync(String scope, String assessmentName) {
        return new PagedFlux(() -> this.listSinglePageAsync(scope, assessmentName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<GovernanceAssignmentInner> listAsync(String scope, String assessmentName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(scope, assessmentName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<GovernanceAssignmentInner> list(String scope, String assessmentName) {
        return new PagedIterable(this.listAsync(scope, assessmentName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<GovernanceAssignmentInner> list(String scope, String assessmentName, Context context) {
        return new PagedIterable(this.listAsync(scope, assessmentName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GovernanceAssignmentInner>> getWithResponseAsync(String scope, String assessmentName, String assignmentKey) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (assessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter assessmentName is required and cannot be null."));
        }
        if (assignmentKey == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter assignmentKey is required and cannot be null."));
        }
        String apiVersion = "2022-01-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2022-01-01-preview", scope, assessmentName, assignmentKey, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GovernanceAssignmentInner>> getWithResponseAsync(String scope, String assessmentName, String assignmentKey, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (assessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter assessmentName is required and cannot be null."));
        }
        if (assignmentKey == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter assignmentKey is required and cannot be null."));
        }
        String apiVersion = "2022-01-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), "2022-01-01-preview", scope, assessmentName, assignmentKey, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GovernanceAssignmentInner> getAsync(String scope, String assessmentName, String assignmentKey) {
        return this.getWithResponseAsync(scope, assessmentName, assignmentKey).flatMap(res -> Mono.justOrEmpty((Object)((Object)((GovernanceAssignmentInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<GovernanceAssignmentInner> getWithResponse(String scope, String assessmentName, String assignmentKey, Context context) {
        return (Response)this.getWithResponseAsync(scope, assessmentName, assignmentKey, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GovernanceAssignmentInner get(String scope, String assessmentName, String assignmentKey) {
        return (GovernanceAssignmentInner)((Object)this.getWithResponse(scope, assessmentName, assignmentKey, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GovernanceAssignmentInner>> createOrUpdateWithResponseAsync(String scope, String assessmentName, String assignmentKey, GovernanceAssignmentInner governanceAssignment) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (assessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter assessmentName is required and cannot be null."));
        }
        if (assignmentKey == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter assignmentKey is required and cannot be null."));
        }
        if (governanceAssignment == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter governanceAssignment is required and cannot be null."));
        }
        governanceAssignment.validate();
        String apiVersion = "2022-01-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), "2022-01-01-preview", scope, assessmentName, assignmentKey, governanceAssignment, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GovernanceAssignmentInner>> createOrUpdateWithResponseAsync(String scope, String assessmentName, String assignmentKey, GovernanceAssignmentInner governanceAssignment, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (assessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter assessmentName is required and cannot be null."));
        }
        if (assignmentKey == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter assignmentKey is required and cannot be null."));
        }
        if (governanceAssignment == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter governanceAssignment is required and cannot be null."));
        }
        governanceAssignment.validate();
        String apiVersion = "2022-01-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), "2022-01-01-preview", scope, assessmentName, assignmentKey, governanceAssignment, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GovernanceAssignmentInner> createOrUpdateAsync(String scope, String assessmentName, String assignmentKey, GovernanceAssignmentInner governanceAssignment) {
        return this.createOrUpdateWithResponseAsync(scope, assessmentName, assignmentKey, governanceAssignment).flatMap(res -> Mono.justOrEmpty((Object)((Object)((GovernanceAssignmentInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<GovernanceAssignmentInner> createOrUpdateWithResponse(String scope, String assessmentName, String assignmentKey, GovernanceAssignmentInner governanceAssignment, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(scope, assessmentName, assignmentKey, governanceAssignment, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GovernanceAssignmentInner createOrUpdate(String scope, String assessmentName, String assignmentKey, GovernanceAssignmentInner governanceAssignment) {
        return (GovernanceAssignmentInner)((Object)this.createOrUpdateWithResponse(scope, assessmentName, assignmentKey, governanceAssignment, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String scope, String assessmentName, String assignmentKey) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (assessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter assessmentName is required and cannot be null."));
        }
        if (assignmentKey == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter assignmentKey is required and cannot be null."));
        }
        String apiVersion = "2022-01-01-preview";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), "2022-01-01-preview", scope, assessmentName, assignmentKey, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String scope, String assessmentName, String assignmentKey, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (assessmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter assessmentName is required and cannot be null."));
        }
        if (assignmentKey == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter assignmentKey is required and cannot be null."));
        }
        String apiVersion = "2022-01-01-preview";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), "2022-01-01-preview", scope, assessmentName, assignmentKey, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String scope, String assessmentName, String assignmentKey) {
        return this.deleteWithResponseAsync(scope, assessmentName, assignmentKey).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String scope, String assessmentName, String assignmentKey, Context context) {
        return (Response)this.deleteWithResponseAsync(scope, assessmentName, assignmentKey, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String scope, String assessmentName, String assignmentKey) {
        this.deleteWithResponse(scope, assessmentName, assignmentKey, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GovernanceAssignmentInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GovernanceAssignmentsList)res.getValue()).value(), ((GovernanceAssignmentsList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GovernanceAssignmentInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GovernanceAssignmentsList)res.getValue()).value(), ((GovernanceAssignmentsList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SecurityCenterGovern")
    public static interface GovernanceAssignmentsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GovernanceAssignmentsList>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="scope") String var3, @PathParam(value="assessmentName") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments/{assignmentKey}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GovernanceAssignmentInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="scope") String var3, @PathParam(value="assessmentName") String var4, @PathParam(value="assignmentKey") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments/{assignmentKey}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GovernanceAssignmentInner>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="scope") String var3, @PathParam(value="assessmentName") String var4, @PathParam(value="assignmentKey") String var5, @BodyParam(value="application/json") GovernanceAssignmentInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments/{assignmentKey}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="scope") String var3, @PathParam(value="assessmentName") String var4, @PathParam(value="assignmentKey") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GovernanceAssignmentsList>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

