/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.GovernanceAssignmentsClient;
import com.azure.resourcemanager.security.fluent.models.GovernanceAssignmentInner;
import com.azure.resourcemanager.security.implementation.GovernanceAssignmentImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.GovernanceAssignment;
import com.azure.resourcemanager.security.models.GovernanceAssignments;

public final class GovernanceAssignmentsImpl
implements GovernanceAssignments {
    private static final ClientLogger LOGGER = new ClientLogger(GovernanceAssignmentsImpl.class);
    private final GovernanceAssignmentsClient innerClient;
    private final SecurityManager serviceManager;

    public GovernanceAssignmentsImpl(GovernanceAssignmentsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<GovernanceAssignment> list(String scope, String assessmentName) {
        PagedIterable<GovernanceAssignmentInner> inner = this.serviceClient().list(scope, assessmentName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GovernanceAssignmentImpl((GovernanceAssignmentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<GovernanceAssignment> list(String scope, String assessmentName, Context context) {
        PagedIterable<GovernanceAssignmentInner> inner = this.serviceClient().list(scope, assessmentName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GovernanceAssignmentImpl((GovernanceAssignmentInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<GovernanceAssignment> getWithResponse(String scope, String assessmentName, String assignmentKey, Context context) {
        Response<GovernanceAssignmentInner> inner = this.serviceClient().getWithResponse(scope, assessmentName, assignmentKey, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new GovernanceAssignmentImpl((GovernanceAssignmentInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public GovernanceAssignment get(String scope, String assessmentName, String assignmentKey) {
        GovernanceAssignmentInner inner = this.serviceClient().get(scope, assessmentName, assignmentKey);
        if (inner != null) {
            return new GovernanceAssignmentImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String scope, String assessmentName, String assignmentKey, Context context) {
        return this.serviceClient().deleteWithResponse(scope, assessmentName, assignmentKey, context);
    }

    @Override
    public void delete(String scope, String assessmentName, String assignmentKey) {
        this.serviceClient().delete(scope, assessmentName, assignmentKey);
    }

    @Override
    public GovernanceAssignment getById(String id) {
        String scope = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments/{assignmentKey}", "scope");
        if (scope == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'scope'.", id)));
        }
        String assessmentName = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments/{assignmentKey}", "assessmentName");
        if (assessmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'assessments'.", id)));
        }
        String assignmentKey = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments/{assignmentKey}", "assignmentKey");
        if (assignmentKey == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'governanceAssignments'.", id)));
        }
        return (GovernanceAssignment)this.getWithResponse(scope, assessmentName, assignmentKey, Context.NONE).getValue();
    }

    @Override
    public Response<GovernanceAssignment> getByIdWithResponse(String id, Context context) {
        String scope = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments/{assignmentKey}", "scope");
        if (scope == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'scope'.", id)));
        }
        String assessmentName = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments/{assignmentKey}", "assessmentName");
        if (assessmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'assessments'.", id)));
        }
        String assignmentKey = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments/{assignmentKey}", "assignmentKey");
        if (assignmentKey == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'governanceAssignments'.", id)));
        }
        return this.getWithResponse(scope, assessmentName, assignmentKey, context);
    }

    @Override
    public void deleteById(String id) {
        String scope = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments/{assignmentKey}", "scope");
        if (scope == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'scope'.", id)));
        }
        String assessmentName = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments/{assignmentKey}", "assessmentName");
        if (assessmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'assessments'.", id)));
        }
        String assignmentKey = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments/{assignmentKey}", "assignmentKey");
        if (assignmentKey == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'governanceAssignments'.", id)));
        }
        this.deleteWithResponse(scope, assessmentName, assignmentKey, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String scope = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments/{assignmentKey}", "scope");
        if (scope == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'scope'.", id)));
        }
        String assessmentName = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments/{assignmentKey}", "assessmentName");
        if (assessmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'assessments'.", id)));
        }
        String assignmentKey = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.Security/assessments/{assessmentName}/governanceAssignments/{assignmentKey}", "assignmentKey");
        if (assignmentKey == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'governanceAssignments'.", id)));
        }
        return this.deleteWithResponse(scope, assessmentName, assignmentKey, context);
    }

    private GovernanceAssignmentsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public GovernanceAssignmentImpl define(String name) {
        return new GovernanceAssignmentImpl(name, this.manager());
    }
}

