/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.GovernanceRulesClient;
import com.azure.resourcemanager.security.fluent.models.GovernanceRuleInner;
import com.azure.resourcemanager.security.fluent.models.OperationResultAutoGeneratedInner;
import com.azure.resourcemanager.security.implementation.GovernanceRuleImpl;
import com.azure.resourcemanager.security.implementation.OperationResultAutoGeneratedImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.ExecuteGovernanceRuleParams;
import com.azure.resourcemanager.security.models.GovernanceRule;
import com.azure.resourcemanager.security.models.GovernanceRules;
import com.azure.resourcemanager.security.models.GovernanceRulesOperationResultsResponse;
import com.azure.resourcemanager.security.models.OperationResultAutoGenerated;

public final class GovernanceRulesImpl
implements GovernanceRules {
    private static final ClientLogger LOGGER = new ClientLogger(GovernanceRulesImpl.class);
    private final GovernanceRulesClient innerClient;
    private final SecurityManager serviceManager;

    public GovernanceRulesImpl(GovernanceRulesClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<GovernanceRule> list(String scope) {
        PagedIterable<GovernanceRuleInner> inner = this.serviceClient().list(scope);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GovernanceRuleImpl((GovernanceRuleInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<GovernanceRule> list(String scope, Context context) {
        PagedIterable<GovernanceRuleInner> inner = this.serviceClient().list(scope, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GovernanceRuleImpl((GovernanceRuleInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<GovernanceRule> getWithResponse(String scope, String ruleId, Context context) {
        Response<GovernanceRuleInner> inner = this.serviceClient().getWithResponse(scope, ruleId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new GovernanceRuleImpl((GovernanceRuleInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public GovernanceRule get(String scope, String ruleId) {
        GovernanceRuleInner inner = this.serviceClient().get(scope, ruleId);
        if (inner != null) {
            return new GovernanceRuleImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String scope, String ruleId) {
        this.serviceClient().delete(scope, ruleId);
    }

    @Override
    public void delete(String scope, String ruleId, Context context) {
        this.serviceClient().delete(scope, ruleId, context);
    }

    @Override
    public void execute(String scope, String ruleId) {
        this.serviceClient().execute(scope, ruleId);
    }

    @Override
    public void execute(String scope, String ruleId, ExecuteGovernanceRuleParams executeGovernanceRuleParams, Context context) {
        this.serviceClient().execute(scope, ruleId, executeGovernanceRuleParams, context);
    }

    @Override
    public Response<OperationResultAutoGenerated> operationResultsWithResponse(String scope, String ruleId, String operationId, Context context) {
        GovernanceRulesOperationResultsResponse inner = this.serviceClient().operationResultsWithResponse(scope, ruleId, operationId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new OperationResultAutoGeneratedImpl(inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public OperationResultAutoGenerated operationResults(String scope, String ruleId, String operationId) {
        OperationResultAutoGeneratedInner inner = this.serviceClient().operationResults(scope, ruleId, operationId);
        if (inner != null) {
            return new OperationResultAutoGeneratedImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public GovernanceRule getById(String id) {
        String scope = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.Security/governanceRules/{ruleId}", "scope");
        if (scope == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'scope'.", id)));
        }
        String ruleId = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.Security/governanceRules/{ruleId}", "ruleId");
        if (ruleId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'governanceRules'.", id)));
        }
        return (GovernanceRule)this.getWithResponse(scope, ruleId, Context.NONE).getValue();
    }

    @Override
    public Response<GovernanceRule> getByIdWithResponse(String id, Context context) {
        String scope = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.Security/governanceRules/{ruleId}", "scope");
        if (scope == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'scope'.", id)));
        }
        String ruleId = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.Security/governanceRules/{ruleId}", "ruleId");
        if (ruleId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'governanceRules'.", id)));
        }
        return this.getWithResponse(scope, ruleId, context);
    }

    @Override
    public void deleteById(String id) {
        String scope = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.Security/governanceRules/{ruleId}", "scope");
        if (scope == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'scope'.", id)));
        }
        String ruleId = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.Security/governanceRules/{ruleId}", "ruleId");
        if (ruleId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'governanceRules'.", id)));
        }
        this.delete(scope, ruleId, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String scope = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.Security/governanceRules/{ruleId}", "scope");
        if (scope == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'scope'.", id)));
        }
        String ruleId = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.Security/governanceRules/{ruleId}", "ruleId");
        if (ruleId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'governanceRules'.", id)));
        }
        this.delete(scope, ruleId, context);
    }

    private GovernanceRulesClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public GovernanceRuleImpl define(String name) {
        return new GovernanceRuleImpl(name, this.manager());
    }
}

