/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.HealthReportsClient;
import com.azure.resourcemanager.security.fluent.models.HealthReportInner;
import com.azure.resourcemanager.security.implementation.HealthReportImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.HealthReport;
import com.azure.resourcemanager.security.models.HealthReports;

public final class HealthReportsImpl
implements HealthReports {
    private static final ClientLogger LOGGER = new ClientLogger(HealthReportsImpl.class);
    private final HealthReportsClient innerClient;
    private final SecurityManager serviceManager;

    public HealthReportsImpl(HealthReportsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<HealthReport> list(String scope) {
        PagedIterable<HealthReportInner> inner = this.serviceClient().list(scope);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new HealthReportImpl((HealthReportInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<HealthReport> list(String scope, Context context) {
        PagedIterable<HealthReportInner> inner = this.serviceClient().list(scope, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new HealthReportImpl((HealthReportInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<HealthReport> getWithResponse(String resourceId, String healthReportName, Context context) {
        Response<HealthReportInner> inner = this.serviceClient().getWithResponse(resourceId, healthReportName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new HealthReportImpl((HealthReportInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public HealthReport get(String resourceId, String healthReportName) {
        HealthReportInner inner = this.serviceClient().get(resourceId, healthReportName);
        if (inner != null) {
            return new HealthReportImpl(inner, this.manager());
        }
        return null;
    }

    private HealthReportsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

