/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.security.fluent.InformationProtectionPoliciesClient;
import com.azure.resourcemanager.security.fluent.models.InformationProtectionPolicyInner;
import com.azure.resourcemanager.security.implementation.SecurityCenterImpl;
import com.azure.resourcemanager.security.models.InformationProtectionPolicyList;
import com.azure.resourcemanager.security.models.InformationProtectionPolicyName;
import reactor.core.publisher.Mono;

public final class InformationProtectionPoliciesClientImpl
implements InformationProtectionPoliciesClient {
    private final InformationProtectionPoliciesService service;
    private final SecurityCenterImpl client;

    InformationProtectionPoliciesClientImpl(SecurityCenterImpl client) {
        this.service = (InformationProtectionPoliciesService)RestProxy.create(InformationProtectionPoliciesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<InformationProtectionPolicyInner>> getWithResponseAsync(String scope, InformationProtectionPolicyName informationProtectionPolicyName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (informationProtectionPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter informationProtectionPolicyName is required and cannot be null."));
        }
        String apiVersion = "2017-08-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2017-08-01-preview", scope, informationProtectionPolicyName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<InformationProtectionPolicyInner>> getWithResponseAsync(String scope, InformationProtectionPolicyName informationProtectionPolicyName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (informationProtectionPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter informationProtectionPolicyName is required and cannot be null."));
        }
        String apiVersion = "2017-08-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), "2017-08-01-preview", scope, informationProtectionPolicyName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<InformationProtectionPolicyInner> getAsync(String scope, InformationProtectionPolicyName informationProtectionPolicyName) {
        return this.getWithResponseAsync(scope, informationProtectionPolicyName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((InformationProtectionPolicyInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<InformationProtectionPolicyInner> getWithResponse(String scope, InformationProtectionPolicyName informationProtectionPolicyName, Context context) {
        return (Response)this.getWithResponseAsync(scope, informationProtectionPolicyName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public InformationProtectionPolicyInner get(String scope, InformationProtectionPolicyName informationProtectionPolicyName) {
        return (InformationProtectionPolicyInner)((Object)this.getWithResponse(scope, informationProtectionPolicyName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<InformationProtectionPolicyInner>> createOrUpdateWithResponseAsync(String scope, InformationProtectionPolicyName informationProtectionPolicyName, InformationProtectionPolicyInner informationProtectionPolicy) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (informationProtectionPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter informationProtectionPolicyName is required and cannot be null."));
        }
        if (informationProtectionPolicy == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter informationProtectionPolicy is required and cannot be null."));
        }
        informationProtectionPolicy.validate();
        String apiVersion = "2017-08-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), "2017-08-01-preview", scope, informationProtectionPolicyName, informationProtectionPolicy, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<InformationProtectionPolicyInner>> createOrUpdateWithResponseAsync(String scope, InformationProtectionPolicyName informationProtectionPolicyName, InformationProtectionPolicyInner informationProtectionPolicy, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (informationProtectionPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter informationProtectionPolicyName is required and cannot be null."));
        }
        if (informationProtectionPolicy == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter informationProtectionPolicy is required and cannot be null."));
        }
        informationProtectionPolicy.validate();
        String apiVersion = "2017-08-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), "2017-08-01-preview", scope, informationProtectionPolicyName, informationProtectionPolicy, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<InformationProtectionPolicyInner> createOrUpdateAsync(String scope, InformationProtectionPolicyName informationProtectionPolicyName, InformationProtectionPolicyInner informationProtectionPolicy) {
        return this.createOrUpdateWithResponseAsync(scope, informationProtectionPolicyName, informationProtectionPolicy).flatMap(res -> Mono.justOrEmpty((Object)((Object)((InformationProtectionPolicyInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<InformationProtectionPolicyInner> createOrUpdateWithResponse(String scope, InformationProtectionPolicyName informationProtectionPolicyName, InformationProtectionPolicyInner informationProtectionPolicy, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(scope, informationProtectionPolicyName, informationProtectionPolicy, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public InformationProtectionPolicyInner createOrUpdate(String scope, InformationProtectionPolicyName informationProtectionPolicyName, InformationProtectionPolicyInner informationProtectionPolicy) {
        return (InformationProtectionPolicyInner)((Object)this.createOrUpdateWithResponse(scope, informationProtectionPolicyName, informationProtectionPolicy, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<InformationProtectionPolicyInner>> listSinglePageAsync(String scope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        String apiVersion = "2017-08-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2017-08-01-preview", scope, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((InformationProtectionPolicyList)res.getValue()).value(), ((InformationProtectionPolicyList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<InformationProtectionPolicyInner>> listSinglePageAsync(String scope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        String apiVersion = "2017-08-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2017-08-01-preview", scope, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((InformationProtectionPolicyList)res.getValue()).value(), ((InformationProtectionPolicyList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<InformationProtectionPolicyInner> listAsync(String scope) {
        return new PagedFlux(() -> this.listSinglePageAsync(scope), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<InformationProtectionPolicyInner> listAsync(String scope, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(scope, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<InformationProtectionPolicyInner> list(String scope) {
        return new PagedIterable(this.listAsync(scope));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<InformationProtectionPolicyInner> list(String scope, Context context) {
        return new PagedIterable(this.listAsync(scope, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<InformationProtectionPolicyInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((InformationProtectionPolicyList)res.getValue()).value(), ((InformationProtectionPolicyList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<InformationProtectionPolicyInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((InformationProtectionPolicyList)res.getValue()).value(), ((InformationProtectionPolicyList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SecurityCenterInform")
    public static interface InformationProtectionPoliciesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{scope}/providers/Microsoft.Security/informationProtectionPolicies/{informationProtectionPolicyName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<InformationProtectionPolicyInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="scope", encoded=true) String var3, @PathParam(value="informationProtectionPolicyName") InformationProtectionPolicyName var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/{scope}/providers/Microsoft.Security/informationProtectionPolicies/{informationProtectionPolicyName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<InformationProtectionPolicyInner>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="scope", encoded=true) String var3, @PathParam(value="informationProtectionPolicyName") InformationProtectionPolicyName var4, @BodyParam(value="application/json") InformationProtectionPolicyInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{scope}/providers/Microsoft.Security/informationProtectionPolicies")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<InformationProtectionPolicyList>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="scope", encoded=true) String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<InformationProtectionPolicyList>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

