/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.InformationProtectionPoliciesClient;
import com.azure.resourcemanager.security.fluent.models.InformationProtectionPolicyInner;
import com.azure.resourcemanager.security.implementation.InformationProtectionPolicyImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.InformationProtectionPolicies;
import com.azure.resourcemanager.security.models.InformationProtectionPolicy;
import com.azure.resourcemanager.security.models.InformationProtectionPolicyName;

public final class InformationProtectionPoliciesImpl
implements InformationProtectionPolicies {
    private static final ClientLogger LOGGER = new ClientLogger(InformationProtectionPoliciesImpl.class);
    private final InformationProtectionPoliciesClient innerClient;
    private final SecurityManager serviceManager;

    public InformationProtectionPoliciesImpl(InformationProtectionPoliciesClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<InformationProtectionPolicy> getWithResponse(String scope, InformationProtectionPolicyName informationProtectionPolicyName, Context context) {
        Response<InformationProtectionPolicyInner> inner = this.serviceClient().getWithResponse(scope, informationProtectionPolicyName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new InformationProtectionPolicyImpl((InformationProtectionPolicyInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public InformationProtectionPolicy get(String scope, InformationProtectionPolicyName informationProtectionPolicyName) {
        InformationProtectionPolicyInner inner = this.serviceClient().get(scope, informationProtectionPolicyName);
        if (inner != null) {
            return new InformationProtectionPolicyImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<InformationProtectionPolicy> list(String scope) {
        PagedIterable<InformationProtectionPolicyInner> inner = this.serviceClient().list(scope);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new InformationProtectionPolicyImpl((InformationProtectionPolicyInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<InformationProtectionPolicy> list(String scope, Context context) {
        PagedIterable<InformationProtectionPolicyInner> inner = this.serviceClient().list(scope, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new InformationProtectionPolicyImpl((InformationProtectionPolicyInner)((Object)inner1), this.manager()));
    }

    @Override
    public InformationProtectionPolicy getById(String id) {
        String scope = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.Security/informationProtectionPolicies/{informationProtectionPolicyName}", "scope");
        if (scope == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'scope'.", id)));
        }
        String informationProtectionPolicyNameLocal = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.Security/informationProtectionPolicies/{informationProtectionPolicyName}", "informationProtectionPolicyName");
        if (informationProtectionPolicyNameLocal == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'informationProtectionPolicies'.", id)));
        }
        InformationProtectionPolicyName informationProtectionPolicyName = InformationProtectionPolicyName.fromString(informationProtectionPolicyNameLocal);
        return (InformationProtectionPolicy)this.getWithResponse(scope, informationProtectionPolicyName, Context.NONE).getValue();
    }

    @Override
    public Response<InformationProtectionPolicy> getByIdWithResponse(String id, Context context) {
        String scope = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.Security/informationProtectionPolicies/{informationProtectionPolicyName}", "scope");
        if (scope == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'scope'.", id)));
        }
        String informationProtectionPolicyNameLocal = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{scope}/providers/Microsoft.Security/informationProtectionPolicies/{informationProtectionPolicyName}", "informationProtectionPolicyName");
        if (informationProtectionPolicyNameLocal == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'informationProtectionPolicies'.", id)));
        }
        InformationProtectionPolicyName informationProtectionPolicyName = InformationProtectionPolicyName.fromString(informationProtectionPolicyNameLocal);
        return this.getWithResponse(scope, informationProtectionPolicyName, context);
    }

    private InformationProtectionPoliciesClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public InformationProtectionPolicyImpl define(InformationProtectionPolicyName name) {
        return new InformationProtectionPolicyImpl(name, this.manager());
    }
}

