/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.models.IoTSecuritySolutionModelInner;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.AdditionalWorkspacesProperties;
import com.azure.resourcemanager.security.models.DataSource;
import com.azure.resourcemanager.security.models.ExportData;
import com.azure.resourcemanager.security.models.IoTSecuritySolutionModel;
import com.azure.resourcemanager.security.models.RecommendationConfigurationProperties;
import com.azure.resourcemanager.security.models.SecuritySolutionStatus;
import com.azure.resourcemanager.security.models.UnmaskedIpLoggingStatus;
import com.azure.resourcemanager.security.models.UpdateIotSecuritySolutionData;
import com.azure.resourcemanager.security.models.UserDefinedResourcesProperties;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class IoTSecuritySolutionModelImpl
implements IoTSecuritySolutionModel,
IoTSecuritySolutionModel.Definition,
IoTSecuritySolutionModel.Update {
    private IoTSecuritySolutionModelInner innerObject;
    private final SecurityManager serviceManager;
    private String resourceGroupName;
    private String solutionName;
    private UpdateIotSecuritySolutionData updateUpdateIotSecuritySolutionData;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Map<String, String> tags() {
        Map<String, String> inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String workspace() {
        return this.innerModel().workspace();
    }

    @Override
    public String displayName() {
        return this.innerModel().displayName();
    }

    @Override
    public SecuritySolutionStatus status() {
        return this.innerModel().status();
    }

    @Override
    public List<ExportData> export() {
        List<ExportData> inner = this.innerModel().export();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<DataSource> disabledDataSources() {
        List<DataSource> inner = this.innerModel().disabledDataSources();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> iotHubs() {
        List<String> inner = this.innerModel().iotHubs();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public UserDefinedResourcesProperties userDefinedResources() {
        return this.innerModel().userDefinedResources();
    }

    @Override
    public List<String> autoDiscoveredResources() {
        List<String> inner = this.innerModel().autoDiscoveredResources();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<RecommendationConfigurationProperties> recommendationsConfiguration() {
        List<RecommendationConfigurationProperties> inner = this.innerModel().recommendationsConfiguration();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public UnmaskedIpLoggingStatus unmaskedIpLoggingStatus() {
        return this.innerModel().unmaskedIpLoggingStatus();
    }

    @Override
    public List<AdditionalWorkspacesProperties> additionalWorkspaces() {
        List<AdditionalWorkspacesProperties> inner = this.innerModel().additionalWorkspaces();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public IoTSecuritySolutionModelInner innerModel() {
        return this.innerObject;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public IoTSecuritySolutionModelImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public IoTSecuritySolutionModel create() {
        this.innerObject = (IoTSecuritySolutionModelInner)((Object)this.serviceManager.serviceClient().getIotSecuritySolutions().createOrUpdateWithResponse(this.resourceGroupName, this.solutionName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public IoTSecuritySolutionModel create(Context context) {
        this.innerObject = (IoTSecuritySolutionModelInner)((Object)this.serviceManager.serviceClient().getIotSecuritySolutions().createOrUpdateWithResponse(this.resourceGroupName, this.solutionName, this.innerModel(), context).getValue());
        return this;
    }

    IoTSecuritySolutionModelImpl(String name, SecurityManager serviceManager) {
        this.innerObject = new IoTSecuritySolutionModelInner();
        this.serviceManager = serviceManager;
        this.solutionName = name;
    }

    @Override
    public IoTSecuritySolutionModelImpl update() {
        this.updateUpdateIotSecuritySolutionData = new UpdateIotSecuritySolutionData();
        return this;
    }

    @Override
    public IoTSecuritySolutionModel apply() {
        this.innerObject = (IoTSecuritySolutionModelInner)((Object)this.serviceManager.serviceClient().getIotSecuritySolutions().updateWithResponse(this.resourceGroupName, this.solutionName, this.updateUpdateIotSecuritySolutionData, Context.NONE).getValue());
        return this;
    }

    @Override
    public IoTSecuritySolutionModel apply(Context context) {
        this.innerObject = (IoTSecuritySolutionModelInner)((Object)this.serviceManager.serviceClient().getIotSecuritySolutions().updateWithResponse(this.resourceGroupName, this.solutionName, this.updateUpdateIotSecuritySolutionData, context).getValue());
        return this;
    }

    IoTSecuritySolutionModelImpl(IoTSecuritySolutionModelInner innerObject, SecurityManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.solutionName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "iotSecuritySolutions");
    }

    @Override
    public IoTSecuritySolutionModel refresh() {
        this.innerObject = (IoTSecuritySolutionModelInner)((Object)this.serviceManager.serviceClient().getIotSecuritySolutions().getByResourceGroupWithResponse(this.resourceGroupName, this.solutionName, Context.NONE).getValue());
        return this;
    }

    @Override
    public IoTSecuritySolutionModel refresh(Context context) {
        this.innerObject = (IoTSecuritySolutionModelInner)((Object)this.serviceManager.serviceClient().getIotSecuritySolutions().getByResourceGroupWithResponse(this.resourceGroupName, this.solutionName, context).getValue());
        return this;
    }

    @Override
    public IoTSecuritySolutionModelImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public IoTSecuritySolutionModelImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public IoTSecuritySolutionModelImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags(tags);
            return this;
        }
        this.updateUpdateIotSecuritySolutionData.withTags((Map)tags);
        return this;
    }

    @Override
    public IoTSecuritySolutionModelImpl withWorkspace(String workspace) {
        this.innerModel().withWorkspace(workspace);
        return this;
    }

    @Override
    public IoTSecuritySolutionModelImpl withDisplayName(String displayName) {
        this.innerModel().withDisplayName(displayName);
        return this;
    }

    @Override
    public IoTSecuritySolutionModelImpl withStatus(SecuritySolutionStatus status) {
        this.innerModel().withStatus(status);
        return this;
    }

    @Override
    public IoTSecuritySolutionModelImpl withExport(List<ExportData> export) {
        this.innerModel().withExport(export);
        return this;
    }

    @Override
    public IoTSecuritySolutionModelImpl withDisabledDataSources(List<DataSource> disabledDataSources) {
        this.innerModel().withDisabledDataSources(disabledDataSources);
        return this;
    }

    @Override
    public IoTSecuritySolutionModelImpl withIotHubs(List<String> iotHubs) {
        this.innerModel().withIotHubs(iotHubs);
        return this;
    }

    @Override
    public IoTSecuritySolutionModelImpl withUserDefinedResources(UserDefinedResourcesProperties userDefinedResources) {
        if (this.isInCreateMode()) {
            this.innerModel().withUserDefinedResources(userDefinedResources);
            return this;
        }
        this.updateUpdateIotSecuritySolutionData.withUserDefinedResources(userDefinedResources);
        return this;
    }

    @Override
    public IoTSecuritySolutionModelImpl withRecommendationsConfiguration(List<RecommendationConfigurationProperties> recommendationsConfiguration) {
        if (this.isInCreateMode()) {
            this.innerModel().withRecommendationsConfiguration(recommendationsConfiguration);
            return this;
        }
        this.updateUpdateIotSecuritySolutionData.withRecommendationsConfiguration(recommendationsConfiguration);
        return this;
    }

    @Override
    public IoTSecuritySolutionModelImpl withUnmaskedIpLoggingStatus(UnmaskedIpLoggingStatus unmaskedIpLoggingStatus) {
        this.innerModel().withUnmaskedIpLoggingStatus(unmaskedIpLoggingStatus);
        return this;
    }

    @Override
    public IoTSecuritySolutionModelImpl withAdditionalWorkspaces(List<AdditionalWorkspacesProperties> additionalWorkspaces) {
        this.innerModel().withAdditionalWorkspaces(additionalWorkspaces);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

