/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.security.fluent.IotSecuritySolutionAnalyticsClient;
import com.azure.resourcemanager.security.fluent.models.IoTSecuritySolutionAnalyticsModelInner;
import com.azure.resourcemanager.security.fluent.models.IoTSecuritySolutionAnalyticsModelListInner;
import com.azure.resourcemanager.security.implementation.SecurityCenterImpl;
import reactor.core.publisher.Mono;

public final class IotSecuritySolutionAnalyticsClientImpl
implements IotSecuritySolutionAnalyticsClient {
    private final IotSecuritySolutionAnalyticsService service;
    private final SecurityCenterImpl client;

    IotSecuritySolutionAnalyticsClientImpl(SecurityCenterImpl client) {
        this.service = (IotSecuritySolutionAnalyticsService)RestProxy.create(IotSecuritySolutionAnalyticsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<IoTSecuritySolutionAnalyticsModelListInner>> listWithResponseAsync(String resourceGroupName, String solutionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (solutionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter solutionName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2019-08-01", this.client.getSubscriptionId(), resourceGroupName, solutionName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<IoTSecuritySolutionAnalyticsModelListInner>> listWithResponseAsync(String resourceGroupName, String solutionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (solutionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter solutionName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2019-08-01", this.client.getSubscriptionId(), resourceGroupName, solutionName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<IoTSecuritySolutionAnalyticsModelListInner> listAsync(String resourceGroupName, String solutionName) {
        return this.listWithResponseAsync(resourceGroupName, solutionName).flatMap(res -> Mono.justOrEmpty((Object)((IoTSecuritySolutionAnalyticsModelListInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IoTSecuritySolutionAnalyticsModelListInner> listWithResponse(String resourceGroupName, String solutionName, Context context) {
        return (Response)this.listWithResponseAsync(resourceGroupName, solutionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public IoTSecuritySolutionAnalyticsModelListInner list(String resourceGroupName, String solutionName) {
        return (IoTSecuritySolutionAnalyticsModelListInner)this.listWithResponse(resourceGroupName, solutionName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<IoTSecuritySolutionAnalyticsModelInner>> getWithResponseAsync(String resourceGroupName, String solutionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (solutionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter solutionName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2019-08-01", this.client.getSubscriptionId(), resourceGroupName, solutionName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<IoTSecuritySolutionAnalyticsModelInner>> getWithResponseAsync(String resourceGroupName, String solutionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (solutionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter solutionName is required and cannot be null."));
        }
        String apiVersion = "2019-08-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), "2019-08-01", this.client.getSubscriptionId(), resourceGroupName, solutionName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<IoTSecuritySolutionAnalyticsModelInner> getAsync(String resourceGroupName, String solutionName) {
        return this.getWithResponseAsync(resourceGroupName, solutionName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((IoTSecuritySolutionAnalyticsModelInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IoTSecuritySolutionAnalyticsModelInner> getWithResponse(String resourceGroupName, String solutionName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, solutionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public IoTSecuritySolutionAnalyticsModelInner get(String resourceGroupName, String solutionName) {
        return (IoTSecuritySolutionAnalyticsModelInner)((Object)this.getWithResponse(resourceGroupName, solutionName, Context.NONE).getValue());
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SecurityCenterIotSec")
    public static interface IotSecuritySolutionAnalyticsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/iotSecuritySolutions/{solutionName}/analyticsModels")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<IoTSecuritySolutionAnalyticsModelListInner>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="solutionName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/iotSecuritySolutions/{solutionName}/analyticsModels/default")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<IoTSecuritySolutionAnalyticsModelInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="solutionName") String var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

