/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.IotSecuritySolutionAnalyticsClient;
import com.azure.resourcemanager.security.fluent.models.IoTSecuritySolutionAnalyticsModelInner;
import com.azure.resourcemanager.security.fluent.models.IoTSecuritySolutionAnalyticsModelListInner;
import com.azure.resourcemanager.security.implementation.IoTSecuritySolutionAnalyticsModelImpl;
import com.azure.resourcemanager.security.implementation.IoTSecuritySolutionAnalyticsModelListImpl;
import com.azure.resourcemanager.security.models.IoTSecuritySolutionAnalyticsModel;
import com.azure.resourcemanager.security.models.IoTSecuritySolutionAnalyticsModelList;
import com.azure.resourcemanager.security.models.IotSecuritySolutionAnalytics;

public final class IotSecuritySolutionAnalyticsImpl
implements IotSecuritySolutionAnalytics {
    private static final ClientLogger LOGGER = new ClientLogger(IotSecuritySolutionAnalyticsImpl.class);
    private final IotSecuritySolutionAnalyticsClient innerClient;
    private final SecurityManager serviceManager;

    public IotSecuritySolutionAnalyticsImpl(IotSecuritySolutionAnalyticsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<IoTSecuritySolutionAnalyticsModelList> listWithResponse(String resourceGroupName, String solutionName, Context context) {
        Response<IoTSecuritySolutionAnalyticsModelListInner> inner = this.serviceClient().listWithResponse(resourceGroupName, solutionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new IoTSecuritySolutionAnalyticsModelListImpl((IoTSecuritySolutionAnalyticsModelListInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public IoTSecuritySolutionAnalyticsModelList list(String resourceGroupName, String solutionName) {
        IoTSecuritySolutionAnalyticsModelListInner inner = this.serviceClient().list(resourceGroupName, solutionName);
        if (inner != null) {
            return new IoTSecuritySolutionAnalyticsModelListImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<IoTSecuritySolutionAnalyticsModel> getWithResponse(String resourceGroupName, String solutionName, Context context) {
        Response<IoTSecuritySolutionAnalyticsModelInner> inner = this.serviceClient().getWithResponse(resourceGroupName, solutionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new IoTSecuritySolutionAnalyticsModelImpl((IoTSecuritySolutionAnalyticsModelInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public IoTSecuritySolutionAnalyticsModel get(String resourceGroupName, String solutionName) {
        IoTSecuritySolutionAnalyticsModelInner inner = this.serviceClient().get(resourceGroupName, solutionName);
        if (inner != null) {
            return new IoTSecuritySolutionAnalyticsModelImpl(inner, this.manager());
        }
        return null;
    }

    private IotSecuritySolutionAnalyticsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

