/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.IotSecuritySolutionsAnalyticsAggregatedAlertsClient;
import com.azure.resourcemanager.security.fluent.models.IoTSecurityAggregatedAlertInner;
import com.azure.resourcemanager.security.implementation.IoTSecurityAggregatedAlertImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.IoTSecurityAggregatedAlert;
import com.azure.resourcemanager.security.models.IotSecuritySolutionsAnalyticsAggregatedAlerts;

public final class IotSecuritySolutionsAnalyticsAggregatedAlertsImpl
implements IotSecuritySolutionsAnalyticsAggregatedAlerts {
    private static final ClientLogger LOGGER = new ClientLogger(IotSecuritySolutionsAnalyticsAggregatedAlertsImpl.class);
    private final IotSecuritySolutionsAnalyticsAggregatedAlertsClient innerClient;
    private final SecurityManager serviceManager;

    public IotSecuritySolutionsAnalyticsAggregatedAlertsImpl(IotSecuritySolutionsAnalyticsAggregatedAlertsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<IoTSecurityAggregatedAlert> list(String resourceGroupName, String solutionName) {
        PagedIterable<IoTSecurityAggregatedAlertInner> inner = this.serviceClient().list(resourceGroupName, solutionName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new IoTSecurityAggregatedAlertImpl((IoTSecurityAggregatedAlertInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<IoTSecurityAggregatedAlert> list(String resourceGroupName, String solutionName, Integer top, Context context) {
        PagedIterable<IoTSecurityAggregatedAlertInner> inner = this.serviceClient().list(resourceGroupName, solutionName, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new IoTSecurityAggregatedAlertImpl((IoTSecurityAggregatedAlertInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<IoTSecurityAggregatedAlert> getWithResponse(String resourceGroupName, String solutionName, String aggregatedAlertName, Context context) {
        Response<IoTSecurityAggregatedAlertInner> inner = this.serviceClient().getWithResponse(resourceGroupName, solutionName, aggregatedAlertName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new IoTSecurityAggregatedAlertImpl((IoTSecurityAggregatedAlertInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public IoTSecurityAggregatedAlert get(String resourceGroupName, String solutionName, String aggregatedAlertName) {
        IoTSecurityAggregatedAlertInner inner = this.serviceClient().get(resourceGroupName, solutionName, aggregatedAlertName);
        if (inner != null) {
            return new IoTSecurityAggregatedAlertImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> dismissWithResponse(String resourceGroupName, String solutionName, String aggregatedAlertName, Context context) {
        return this.serviceClient().dismissWithResponse(resourceGroupName, solutionName, aggregatedAlertName, context);
    }

    @Override
    public void dismiss(String resourceGroupName, String solutionName, String aggregatedAlertName) {
        this.serviceClient().dismiss(resourceGroupName, solutionName, aggregatedAlertName);
    }

    private IotSecuritySolutionsAnalyticsAggregatedAlertsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

