/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.IotSecuritySolutionsAnalyticsRecommendationsClient;
import com.azure.resourcemanager.security.fluent.models.IoTSecurityAggregatedRecommendationInner;
import com.azure.resourcemanager.security.implementation.IoTSecurityAggregatedRecommendationImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.IoTSecurityAggregatedRecommendation;
import com.azure.resourcemanager.security.models.IotSecuritySolutionsAnalyticsRecommendations;

public final class IotSecuritySolutionsAnalyticsRecommendationsImpl
implements IotSecuritySolutionsAnalyticsRecommendations {
    private static final ClientLogger LOGGER = new ClientLogger(IotSecuritySolutionsAnalyticsRecommendationsImpl.class);
    private final IotSecuritySolutionsAnalyticsRecommendationsClient innerClient;
    private final SecurityManager serviceManager;

    public IotSecuritySolutionsAnalyticsRecommendationsImpl(IotSecuritySolutionsAnalyticsRecommendationsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<IoTSecurityAggregatedRecommendation> getWithResponse(String resourceGroupName, String solutionName, String aggregatedRecommendationName, Context context) {
        Response<IoTSecurityAggregatedRecommendationInner> inner = this.serviceClient().getWithResponse(resourceGroupName, solutionName, aggregatedRecommendationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new IoTSecurityAggregatedRecommendationImpl((IoTSecurityAggregatedRecommendationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public IoTSecurityAggregatedRecommendation get(String resourceGroupName, String solutionName, String aggregatedRecommendationName) {
        IoTSecurityAggregatedRecommendationInner inner = this.serviceClient().get(resourceGroupName, solutionName, aggregatedRecommendationName);
        if (inner != null) {
            return new IoTSecurityAggregatedRecommendationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<IoTSecurityAggregatedRecommendation> list(String resourceGroupName, String solutionName) {
        PagedIterable<IoTSecurityAggregatedRecommendationInner> inner = this.serviceClient().list(resourceGroupName, solutionName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new IoTSecurityAggregatedRecommendationImpl((IoTSecurityAggregatedRecommendationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<IoTSecurityAggregatedRecommendation> list(String resourceGroupName, String solutionName, Integer top, Context context) {
        PagedIterable<IoTSecurityAggregatedRecommendationInner> inner = this.serviceClient().list(resourceGroupName, solutionName, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new IoTSecurityAggregatedRecommendationImpl((IoTSecurityAggregatedRecommendationInner)((Object)inner1), this.manager()));
    }

    private IotSecuritySolutionsAnalyticsRecommendationsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

