/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.security.fluent.JitNetworkAccessPoliciesClient;
import com.azure.resourcemanager.security.fluent.models.JitNetworkAccessPolicyInner;
import com.azure.resourcemanager.security.fluent.models.JitNetworkAccessRequestInner;
import com.azure.resourcemanager.security.implementation.SecurityCenterImpl;
import com.azure.resourcemanager.security.models.JitNetworkAccessPoliciesList;
import com.azure.resourcemanager.security.models.JitNetworkAccessPolicyInitiateRequest;
import reactor.core.publisher.Mono;

public final class JitNetworkAccessPoliciesClientImpl
implements JitNetworkAccessPoliciesClient {
    private final JitNetworkAccessPoliciesService service;
    private final SecurityCenterImpl client;

    JitNetworkAccessPoliciesClientImpl(SecurityCenterImpl client) {
        this.service = (JitNetworkAccessPoliciesService)RestProxy.create(JitNetworkAccessPoliciesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JitNetworkAccessPolicyInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), "2020-01-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JitNetworkAccessPoliciesList)res.getValue()).value(), ((JitNetworkAccessPoliciesList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JitNetworkAccessPolicyInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), "2020-01-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JitNetworkAccessPoliciesList)res.getValue()).value(), ((JitNetworkAccessPoliciesList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<JitNetworkAccessPolicyInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync(), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<JitNetworkAccessPolicyInner> listAsync(Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<JitNetworkAccessPolicyInner> list() {
        return new PagedIterable(this.listAsync());
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<JitNetworkAccessPolicyInner> list(Context context) {
        return new PagedIterable(this.listAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JitNetworkAccessPolicyInner>> listByRegionSinglePageAsync(String ascLocation) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByRegion(this.client.getEndpoint(), this.client.getSubscriptionId(), ascLocation, "2020-01-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JitNetworkAccessPoliciesList)res.getValue()).value(), ((JitNetworkAccessPoliciesList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JitNetworkAccessPolicyInner>> listByRegionSinglePageAsync(String ascLocation, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByRegion(this.client.getEndpoint(), this.client.getSubscriptionId(), ascLocation, "2020-01-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JitNetworkAccessPoliciesList)res.getValue()).value(), ((JitNetworkAccessPoliciesList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<JitNetworkAccessPolicyInner> listByRegionAsync(String ascLocation) {
        return new PagedFlux(() -> this.listByRegionSinglePageAsync(ascLocation), nextLink -> this.listByRegionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<JitNetworkAccessPolicyInner> listByRegionAsync(String ascLocation, Context context) {
        return new PagedFlux(() -> this.listByRegionSinglePageAsync(ascLocation, context), nextLink -> this.listByRegionNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<JitNetworkAccessPolicyInner> listByRegion(String ascLocation) {
        return new PagedIterable(this.listByRegionAsync(ascLocation));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<JitNetworkAccessPolicyInner> listByRegion(String ascLocation, Context context) {
        return new PagedIterable(this.listByRegionAsync(ascLocation, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JitNetworkAccessPolicyInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2020-01-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JitNetworkAccessPoliciesList)res.getValue()).value(), ((JitNetworkAccessPoliciesList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JitNetworkAccessPolicyInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, "2020-01-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JitNetworkAccessPoliciesList)res.getValue()).value(), ((JitNetworkAccessPoliciesList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<JitNetworkAccessPolicyInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<JitNetworkAccessPolicyInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, context), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<JitNetworkAccessPolicyInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<JitNetworkAccessPolicyInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JitNetworkAccessPolicyInner>> listByResourceGroupAndRegionSinglePageAsync(String resourceGroupName, String ascLocation) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupAndRegion(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, ascLocation, "2020-01-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JitNetworkAccessPoliciesList)res.getValue()).value(), ((JitNetworkAccessPoliciesList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JitNetworkAccessPolicyInner>> listByResourceGroupAndRegionSinglePageAsync(String resourceGroupName, String ascLocation, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroupAndRegion(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, ascLocation, "2020-01-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JitNetworkAccessPoliciesList)res.getValue()).value(), ((JitNetworkAccessPoliciesList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<JitNetworkAccessPolicyInner> listByResourceGroupAndRegionAsync(String resourceGroupName, String ascLocation) {
        return new PagedFlux(() -> this.listByResourceGroupAndRegionSinglePageAsync(resourceGroupName, ascLocation), nextLink -> this.listByResourceGroupAndRegionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<JitNetworkAccessPolicyInner> listByResourceGroupAndRegionAsync(String resourceGroupName, String ascLocation, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupAndRegionSinglePageAsync(resourceGroupName, ascLocation, context), nextLink -> this.listByResourceGroupAndRegionNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<JitNetworkAccessPolicyInner> listByResourceGroupAndRegion(String resourceGroupName, String ascLocation) {
        return new PagedIterable(this.listByResourceGroupAndRegionAsync(resourceGroupName, ascLocation));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<JitNetworkAccessPolicyInner> listByResourceGroupAndRegion(String resourceGroupName, String ascLocation, Context context) {
        return new PagedIterable(this.listByResourceGroupAndRegionAsync(resourceGroupName, ascLocation, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<JitNetworkAccessPolicyInner>> getWithResponseAsync(String resourceGroupName, String ascLocation, String jitNetworkAccessPolicyName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (jitNetworkAccessPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jitNetworkAccessPolicyName is required and cannot be null."));
        }
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, ascLocation, jitNetworkAccessPolicyName, "2020-01-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<JitNetworkAccessPolicyInner>> getWithResponseAsync(String resourceGroupName, String ascLocation, String jitNetworkAccessPolicyName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (jitNetworkAccessPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jitNetworkAccessPolicyName is required and cannot be null."));
        }
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, ascLocation, jitNetworkAccessPolicyName, "2020-01-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<JitNetworkAccessPolicyInner> getAsync(String resourceGroupName, String ascLocation, String jitNetworkAccessPolicyName) {
        return this.getWithResponseAsync(resourceGroupName, ascLocation, jitNetworkAccessPolicyName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((JitNetworkAccessPolicyInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<JitNetworkAccessPolicyInner> getWithResponse(String resourceGroupName, String ascLocation, String jitNetworkAccessPolicyName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, ascLocation, jitNetworkAccessPolicyName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public JitNetworkAccessPolicyInner get(String resourceGroupName, String ascLocation, String jitNetworkAccessPolicyName) {
        return (JitNetworkAccessPolicyInner)((Object)this.getWithResponse(resourceGroupName, ascLocation, jitNetworkAccessPolicyName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<JitNetworkAccessPolicyInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String ascLocation, String jitNetworkAccessPolicyName, JitNetworkAccessPolicyInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (jitNetworkAccessPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jitNetworkAccessPolicyName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, ascLocation, jitNetworkAccessPolicyName, "2020-01-01", body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<JitNetworkAccessPolicyInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String ascLocation, String jitNetworkAccessPolicyName, JitNetworkAccessPolicyInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (jitNetworkAccessPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jitNetworkAccessPolicyName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, ascLocation, jitNetworkAccessPolicyName, "2020-01-01", body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<JitNetworkAccessPolicyInner> createOrUpdateAsync(String resourceGroupName, String ascLocation, String jitNetworkAccessPolicyName, JitNetworkAccessPolicyInner body) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, ascLocation, jitNetworkAccessPolicyName, body).flatMap(res -> Mono.justOrEmpty((Object)((Object)((JitNetworkAccessPolicyInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<JitNetworkAccessPolicyInner> createOrUpdateWithResponse(String resourceGroupName, String ascLocation, String jitNetworkAccessPolicyName, JitNetworkAccessPolicyInner body, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, ascLocation, jitNetworkAccessPolicyName, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public JitNetworkAccessPolicyInner createOrUpdate(String resourceGroupName, String ascLocation, String jitNetworkAccessPolicyName, JitNetworkAccessPolicyInner body) {
        return (JitNetworkAccessPolicyInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, ascLocation, jitNetworkAccessPolicyName, body, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String ascLocation, String jitNetworkAccessPolicyName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (jitNetworkAccessPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jitNetworkAccessPolicyName is required and cannot be null."));
        }
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, ascLocation, jitNetworkAccessPolicyName, "2020-01-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String ascLocation, String jitNetworkAccessPolicyName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (jitNetworkAccessPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jitNetworkAccessPolicyName is required and cannot be null."));
        }
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, ascLocation, jitNetworkAccessPolicyName, "2020-01-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String ascLocation, String jitNetworkAccessPolicyName) {
        return this.deleteWithResponseAsync(resourceGroupName, ascLocation, jitNetworkAccessPolicyName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String ascLocation, String jitNetworkAccessPolicyName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, ascLocation, jitNetworkAccessPolicyName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String ascLocation, String jitNetworkAccessPolicyName) {
        this.deleteWithResponse(resourceGroupName, ascLocation, jitNetworkAccessPolicyName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<JitNetworkAccessRequestInner>> initiateWithResponseAsync(String resourceGroupName, String ascLocation, String jitNetworkAccessPolicyName, JitNetworkAccessPolicyInitiateRequest body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (jitNetworkAccessPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jitNetworkAccessPolicyName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String jitNetworkAccessPolicyInitiateType = "initiate";
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.initiate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, ascLocation, jitNetworkAccessPolicyName, "initiate", "2020-01-01", body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<JitNetworkAccessRequestInner>> initiateWithResponseAsync(String resourceGroupName, String ascLocation, String jitNetworkAccessPolicyName, JitNetworkAccessPolicyInitiateRequest body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (jitNetworkAccessPolicyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jitNetworkAccessPolicyName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String jitNetworkAccessPolicyInitiateType = "initiate";
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.initiate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, ascLocation, jitNetworkAccessPolicyName, "initiate", "2020-01-01", body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<JitNetworkAccessRequestInner> initiateAsync(String resourceGroupName, String ascLocation, String jitNetworkAccessPolicyName, JitNetworkAccessPolicyInitiateRequest body) {
        return this.initiateWithResponseAsync(resourceGroupName, ascLocation, jitNetworkAccessPolicyName, body).flatMap(res -> Mono.justOrEmpty((Object)((JitNetworkAccessRequestInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<JitNetworkAccessRequestInner> initiateWithResponse(String resourceGroupName, String ascLocation, String jitNetworkAccessPolicyName, JitNetworkAccessPolicyInitiateRequest body, Context context) {
        return (Response)this.initiateWithResponseAsync(resourceGroupName, ascLocation, jitNetworkAccessPolicyName, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public JitNetworkAccessRequestInner initiate(String resourceGroupName, String ascLocation, String jitNetworkAccessPolicyName, JitNetworkAccessPolicyInitiateRequest body) {
        return (JitNetworkAccessRequestInner)this.initiateWithResponse(resourceGroupName, ascLocation, jitNetworkAccessPolicyName, body, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JitNetworkAccessPolicyInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JitNetworkAccessPoliciesList)res.getValue()).value(), ((JitNetworkAccessPoliciesList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JitNetworkAccessPolicyInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JitNetworkAccessPoliciesList)res.getValue()).value(), ((JitNetworkAccessPoliciesList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JitNetworkAccessPolicyInner>> listByRegionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByRegionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JitNetworkAccessPoliciesList)res.getValue()).value(), ((JitNetworkAccessPoliciesList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JitNetworkAccessPolicyInner>> listByRegionNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByRegionNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JitNetworkAccessPoliciesList)res.getValue()).value(), ((JitNetworkAccessPoliciesList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JitNetworkAccessPolicyInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JitNetworkAccessPoliciesList)res.getValue()).value(), ((JitNetworkAccessPoliciesList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JitNetworkAccessPolicyInner>> listByResourceGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JitNetworkAccessPoliciesList)res.getValue()).value(), ((JitNetworkAccessPoliciesList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JitNetworkAccessPolicyInner>> listByResourceGroupAndRegionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupAndRegionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JitNetworkAccessPoliciesList)res.getValue()).value(), ((JitNetworkAccessPoliciesList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JitNetworkAccessPolicyInner>> listByResourceGroupAndRegionNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroupAndRegionNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JitNetworkAccessPoliciesList)res.getValue()).value(), ((JitNetworkAccessPoliciesList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SecurityCenterJitNet")
    public static interface JitNetworkAccessPoliciesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/jitNetworkAccessPolicies")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JitNetworkAccessPoliciesList>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/jitNetworkAccessPolicies")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JitNetworkAccessPoliciesList>> listByRegion(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="ascLocation") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/jitNetworkAccessPolicies")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JitNetworkAccessPoliciesList>> listByResourceGroup(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/jitNetworkAccessPolicies")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JitNetworkAccessPoliciesList>> listByResourceGroupAndRegion(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="ascLocation") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/jitNetworkAccessPolicies/{jitNetworkAccessPolicyName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JitNetworkAccessPolicyInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="ascLocation") String var4, @PathParam(value="jitNetworkAccessPolicyName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/jitNetworkAccessPolicies/{jitNetworkAccessPolicyName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JitNetworkAccessPolicyInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="ascLocation") String var4, @PathParam(value="jitNetworkAccessPolicyName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") JitNetworkAccessPolicyInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/jitNetworkAccessPolicies/{jitNetworkAccessPolicyName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="ascLocation") String var4, @PathParam(value="jitNetworkAccessPolicyName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/jitNetworkAccessPolicies/{jitNetworkAccessPolicyName}/{jitNetworkAccessPolicyInitiateType}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JitNetworkAccessRequestInner>> initiate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="ascLocation") String var4, @PathParam(value="jitNetworkAccessPolicyName") String var5, @PathParam(value="jitNetworkAccessPolicyInitiateType") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") JitNetworkAccessPolicyInitiateRequest var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JitNetworkAccessPoliciesList>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JitNetworkAccessPoliciesList>> listByRegionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JitNetworkAccessPoliciesList>> listByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JitNetworkAccessPoliciesList>> listByResourceGroupAndRegionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

