/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.JitNetworkAccessPoliciesClient;
import com.azure.resourcemanager.security.fluent.models.JitNetworkAccessPolicyInner;
import com.azure.resourcemanager.security.fluent.models.JitNetworkAccessRequestInner;
import com.azure.resourcemanager.security.implementation.JitNetworkAccessPolicyImpl;
import com.azure.resourcemanager.security.implementation.JitNetworkAccessRequestImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.JitNetworkAccessPolicies;
import com.azure.resourcemanager.security.models.JitNetworkAccessPolicy;
import com.azure.resourcemanager.security.models.JitNetworkAccessPolicyInitiateRequest;
import com.azure.resourcemanager.security.models.JitNetworkAccessRequest;

public final class JitNetworkAccessPoliciesImpl
implements JitNetworkAccessPolicies {
    private static final ClientLogger LOGGER = new ClientLogger(JitNetworkAccessPoliciesImpl.class);
    private final JitNetworkAccessPoliciesClient innerClient;
    private final SecurityManager serviceManager;

    public JitNetworkAccessPoliciesImpl(JitNetworkAccessPoliciesClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<JitNetworkAccessPolicy> list() {
        PagedIterable<JitNetworkAccessPolicyInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new JitNetworkAccessPolicyImpl((JitNetworkAccessPolicyInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<JitNetworkAccessPolicy> list(Context context) {
        PagedIterable<JitNetworkAccessPolicyInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new JitNetworkAccessPolicyImpl((JitNetworkAccessPolicyInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<JitNetworkAccessPolicy> listByRegion(String ascLocation) {
        PagedIterable<JitNetworkAccessPolicyInner> inner = this.serviceClient().listByRegion(ascLocation);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new JitNetworkAccessPolicyImpl((JitNetworkAccessPolicyInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<JitNetworkAccessPolicy> listByRegion(String ascLocation, Context context) {
        PagedIterable<JitNetworkAccessPolicyInner> inner = this.serviceClient().listByRegion(ascLocation, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new JitNetworkAccessPolicyImpl((JitNetworkAccessPolicyInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<JitNetworkAccessPolicy> listByResourceGroup(String resourceGroupName) {
        PagedIterable<JitNetworkAccessPolicyInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new JitNetworkAccessPolicyImpl((JitNetworkAccessPolicyInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<JitNetworkAccessPolicy> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<JitNetworkAccessPolicyInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new JitNetworkAccessPolicyImpl((JitNetworkAccessPolicyInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<JitNetworkAccessPolicy> listByResourceGroupAndRegion(String resourceGroupName, String ascLocation) {
        PagedIterable<JitNetworkAccessPolicyInner> inner = this.serviceClient().listByResourceGroupAndRegion(resourceGroupName, ascLocation);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new JitNetworkAccessPolicyImpl((JitNetworkAccessPolicyInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<JitNetworkAccessPolicy> listByResourceGroupAndRegion(String resourceGroupName, String ascLocation, Context context) {
        PagedIterable<JitNetworkAccessPolicyInner> inner = this.serviceClient().listByResourceGroupAndRegion(resourceGroupName, ascLocation, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new JitNetworkAccessPolicyImpl((JitNetworkAccessPolicyInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<JitNetworkAccessPolicy> getWithResponse(String resourceGroupName, String ascLocation, String jitNetworkAccessPolicyName, Context context) {
        Response<JitNetworkAccessPolicyInner> inner = this.serviceClient().getWithResponse(resourceGroupName, ascLocation, jitNetworkAccessPolicyName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new JitNetworkAccessPolicyImpl((JitNetworkAccessPolicyInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public JitNetworkAccessPolicy get(String resourceGroupName, String ascLocation, String jitNetworkAccessPolicyName) {
        JitNetworkAccessPolicyInner inner = this.serviceClient().get(resourceGroupName, ascLocation, jitNetworkAccessPolicyName);
        if (inner != null) {
            return new JitNetworkAccessPolicyImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String ascLocation, String jitNetworkAccessPolicyName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, ascLocation, jitNetworkAccessPolicyName, context);
    }

    @Override
    public void delete(String resourceGroupName, String ascLocation, String jitNetworkAccessPolicyName) {
        this.serviceClient().delete(resourceGroupName, ascLocation, jitNetworkAccessPolicyName);
    }

    @Override
    public Response<JitNetworkAccessRequest> initiateWithResponse(String resourceGroupName, String ascLocation, String jitNetworkAccessPolicyName, JitNetworkAccessPolicyInitiateRequest body, Context context) {
        Response<JitNetworkAccessRequestInner> inner = this.serviceClient().initiateWithResponse(resourceGroupName, ascLocation, jitNetworkAccessPolicyName, body, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new JitNetworkAccessRequestImpl((JitNetworkAccessRequestInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public JitNetworkAccessRequest initiate(String resourceGroupName, String ascLocation, String jitNetworkAccessPolicyName, JitNetworkAccessPolicyInitiateRequest body) {
        JitNetworkAccessRequestInner inner = this.serviceClient().initiate(resourceGroupName, ascLocation, jitNetworkAccessPolicyName, body);
        if (inner != null) {
            return new JitNetworkAccessRequestImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public JitNetworkAccessPolicy getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String ascLocation = ResourceManagerUtils.getValueFromIdByName(id, "locations");
        if (ascLocation == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'locations'.", id)));
        }
        String jitNetworkAccessPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "jitNetworkAccessPolicies");
        if (jitNetworkAccessPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'jitNetworkAccessPolicies'.", id)));
        }
        return (JitNetworkAccessPolicy)this.getWithResponse(resourceGroupName, ascLocation, jitNetworkAccessPolicyName, Context.NONE).getValue();
    }

    @Override
    public Response<JitNetworkAccessPolicy> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String ascLocation = ResourceManagerUtils.getValueFromIdByName(id, "locations");
        if (ascLocation == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'locations'.", id)));
        }
        String jitNetworkAccessPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "jitNetworkAccessPolicies");
        if (jitNetworkAccessPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'jitNetworkAccessPolicies'.", id)));
        }
        return this.getWithResponse(resourceGroupName, ascLocation, jitNetworkAccessPolicyName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String ascLocation = ResourceManagerUtils.getValueFromIdByName(id, "locations");
        if (ascLocation == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'locations'.", id)));
        }
        String jitNetworkAccessPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "jitNetworkAccessPolicies");
        if (jitNetworkAccessPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'jitNetworkAccessPolicies'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, ascLocation, jitNetworkAccessPolicyName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String ascLocation = ResourceManagerUtils.getValueFromIdByName(id, "locations");
        if (ascLocation == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'locations'.", id)));
        }
        String jitNetworkAccessPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "jitNetworkAccessPolicies");
        if (jitNetworkAccessPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'jitNetworkAccessPolicies'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, ascLocation, jitNetworkAccessPolicyName, context);
    }

    private JitNetworkAccessPoliciesClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public JitNetworkAccessPolicyImpl define(String name) {
        return new JitNetworkAccessPolicyImpl(name, this.manager());
    }
}

