/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.models.JitNetworkAccessPolicyInner;
import com.azure.resourcemanager.security.fluent.models.JitNetworkAccessRequestInner;
import com.azure.resourcemanager.security.implementation.JitNetworkAccessRequestImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.JitNetworkAccessPolicy;
import com.azure.resourcemanager.security.models.JitNetworkAccessPolicyVirtualMachine;
import com.azure.resourcemanager.security.models.JitNetworkAccessRequest;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class JitNetworkAccessPolicyImpl
implements JitNetworkAccessPolicy,
JitNetworkAccessPolicy.Definition,
JitNetworkAccessPolicy.Update {
    private JitNetworkAccessPolicyInner innerObject;
    private final SecurityManager serviceManager;
    private String resourceGroupName;
    private String ascLocation;
    private String jitNetworkAccessPolicyName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String kind() {
        return this.innerModel().kind();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public List<JitNetworkAccessPolicyVirtualMachine> virtualMachines() {
        List<JitNetworkAccessPolicyVirtualMachine> inner = this.innerModel().virtualMachines();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<JitNetworkAccessRequest> requests() {
        List<JitNetworkAccessRequestInner> inner = this.innerModel().requests();
        if (inner != null) {
            return Collections.unmodifiableList(inner.stream().map(inner1 -> new JitNetworkAccessRequestImpl((JitNetworkAccessRequestInner)inner1, this.manager())).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    @Override
    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public JitNetworkAccessPolicyInner innerModel() {
        return this.innerObject;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public JitNetworkAccessPolicyImpl withExistingLocation(String resourceGroupName, String ascLocation) {
        this.resourceGroupName = resourceGroupName;
        this.ascLocation = ascLocation;
        return this;
    }

    @Override
    public JitNetworkAccessPolicy create() {
        this.innerObject = (JitNetworkAccessPolicyInner)((Object)this.serviceManager.serviceClient().getJitNetworkAccessPolicies().createOrUpdateWithResponse(this.resourceGroupName, this.ascLocation, this.jitNetworkAccessPolicyName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public JitNetworkAccessPolicy create(Context context) {
        this.innerObject = (JitNetworkAccessPolicyInner)((Object)this.serviceManager.serviceClient().getJitNetworkAccessPolicies().createOrUpdateWithResponse(this.resourceGroupName, this.ascLocation, this.jitNetworkAccessPolicyName, this.innerModel(), context).getValue());
        return this;
    }

    JitNetworkAccessPolicyImpl(String name, SecurityManager serviceManager) {
        this.innerObject = new JitNetworkAccessPolicyInner();
        this.serviceManager = serviceManager;
        this.jitNetworkAccessPolicyName = name;
    }

    @Override
    public JitNetworkAccessPolicyImpl update() {
        return this;
    }

    @Override
    public JitNetworkAccessPolicy apply() {
        this.innerObject = (JitNetworkAccessPolicyInner)((Object)this.serviceManager.serviceClient().getJitNetworkAccessPolicies().createOrUpdateWithResponse(this.resourceGroupName, this.ascLocation, this.jitNetworkAccessPolicyName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public JitNetworkAccessPolicy apply(Context context) {
        this.innerObject = (JitNetworkAccessPolicyInner)((Object)this.serviceManager.serviceClient().getJitNetworkAccessPolicies().createOrUpdateWithResponse(this.resourceGroupName, this.ascLocation, this.jitNetworkAccessPolicyName, this.innerModel(), context).getValue());
        return this;
    }

    JitNetworkAccessPolicyImpl(JitNetworkAccessPolicyInner innerObject, SecurityManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.ascLocation = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "locations");
        this.jitNetworkAccessPolicyName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "jitNetworkAccessPolicies");
    }

    @Override
    public JitNetworkAccessPolicy refresh() {
        this.innerObject = (JitNetworkAccessPolicyInner)((Object)this.serviceManager.serviceClient().getJitNetworkAccessPolicies().getWithResponse(this.resourceGroupName, this.ascLocation, this.jitNetworkAccessPolicyName, Context.NONE).getValue());
        return this;
    }

    @Override
    public JitNetworkAccessPolicy refresh(Context context) {
        this.innerObject = (JitNetworkAccessPolicyInner)((Object)this.serviceManager.serviceClient().getJitNetworkAccessPolicies().getWithResponse(this.resourceGroupName, this.ascLocation, this.jitNetworkAccessPolicyName, context).getValue());
        return this;
    }

    @Override
    public JitNetworkAccessPolicyImpl withVirtualMachines(List<JitNetworkAccessPolicyVirtualMachine> virtualMachines) {
        this.innerModel().withVirtualMachines(virtualMachines);
        return this;
    }

    @Override
    public JitNetworkAccessPolicyImpl withKind(String kind) {
        this.innerModel().withKind(kind);
        return this;
    }

    @Override
    public JitNetworkAccessPolicyImpl withRequests(List<JitNetworkAccessRequestInner> requests) {
        this.innerModel().withRequests(requests);
        return this;
    }
}

