/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.security.fluent.PricingsClient;
import com.azure.resourcemanager.security.fluent.models.PricingInner;
import com.azure.resourcemanager.security.fluent.models.PricingListInner;
import com.azure.resourcemanager.security.implementation.SecurityCenterImpl;
import reactor.core.publisher.Mono;

public final class PricingsClientImpl
implements PricingsClient {
    private final PricingsService service;
    private final SecurityCenterImpl client;

    PricingsClientImpl(SecurityCenterImpl client) {
        this.service = (PricingsService)RestProxy.create(PricingsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PricingInner>> getWithResponseAsync(String scopeId, String pricingName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scopeId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeId is required and cannot be null."));
        }
        if (pricingName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter pricingName is required and cannot be null."));
        }
        String apiVersion = "2024-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2024-01-01", scopeId, pricingName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PricingInner>> getWithResponseAsync(String scopeId, String pricingName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scopeId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeId is required and cannot be null."));
        }
        if (pricingName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter pricingName is required and cannot be null."));
        }
        String apiVersion = "2024-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), "2024-01-01", scopeId, pricingName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PricingInner> getAsync(String scopeId, String pricingName) {
        return this.getWithResponseAsync(scopeId, pricingName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((PricingInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PricingInner> getWithResponse(String scopeId, String pricingName, Context context) {
        return (Response)this.getWithResponseAsync(scopeId, pricingName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PricingInner get(String scopeId, String pricingName) {
        return (PricingInner)((Object)this.getWithResponse(scopeId, pricingName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PricingInner>> updateWithResponseAsync(String scopeId, String pricingName, PricingInner pricing) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scopeId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeId is required and cannot be null."));
        }
        if (pricingName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter pricingName is required and cannot be null."));
        }
        if (pricing == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter pricing is required and cannot be null."));
        }
        pricing.validate();
        String apiVersion = "2024-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), "2024-01-01", scopeId, pricingName, pricing, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PricingInner>> updateWithResponseAsync(String scopeId, String pricingName, PricingInner pricing, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scopeId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeId is required and cannot be null."));
        }
        if (pricingName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter pricingName is required and cannot be null."));
        }
        if (pricing == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter pricing is required and cannot be null."));
        }
        pricing.validate();
        String apiVersion = "2024-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), "2024-01-01", scopeId, pricingName, pricing, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PricingInner> updateAsync(String scopeId, String pricingName, PricingInner pricing) {
        return this.updateWithResponseAsync(scopeId, pricingName, pricing).flatMap(res -> Mono.justOrEmpty((Object)((Object)((PricingInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PricingInner> updateWithResponse(String scopeId, String pricingName, PricingInner pricing, Context context) {
        return (Response)this.updateWithResponseAsync(scopeId, pricingName, pricing, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PricingInner update(String scopeId, String pricingName, PricingInner pricing) {
        return (PricingInner)((Object)this.updateWithResponse(scopeId, pricingName, pricing, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String scopeId, String pricingName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scopeId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeId is required and cannot be null."));
        }
        if (pricingName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter pricingName is required and cannot be null."));
        }
        String apiVersion = "2024-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), "2024-01-01", scopeId, pricingName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String scopeId, String pricingName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scopeId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeId is required and cannot be null."));
        }
        if (pricingName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter pricingName is required and cannot be null."));
        }
        String apiVersion = "2024-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), "2024-01-01", scopeId, pricingName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String scopeId, String pricingName) {
        return this.deleteWithResponseAsync(scopeId, pricingName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String scopeId, String pricingName, Context context) {
        return (Response)this.deleteWithResponseAsync(scopeId, pricingName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String scopeId, String pricingName) {
        this.deleteWithResponse(scopeId, pricingName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PricingListInner>> listWithResponseAsync(String scopeId, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scopeId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeId is required and cannot be null."));
        }
        String apiVersion = "2024-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2024-01-01", scopeId, filter, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PricingListInner>> listWithResponseAsync(String scopeId, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scopeId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopeId is required and cannot be null."));
        }
        String apiVersion = "2024-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2024-01-01", scopeId, filter, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PricingListInner> listAsync(String scopeId) {
        String filter = null;
        return this.listWithResponseAsync(scopeId, filter).flatMap(res -> Mono.justOrEmpty((Object)((PricingListInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PricingListInner> listWithResponse(String scopeId, String filter, Context context) {
        return (Response)this.listWithResponseAsync(scopeId, filter, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PricingListInner list(String scopeId) {
        String filter = null;
        return (PricingListInner)this.listWithResponse(scopeId, filter, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SecurityCenterPricin")
    public static interface PricingsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{scopeId}/providers/Microsoft.Security/pricings/{pricingName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PricingInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="scopeId", encoded=true) String var3, @PathParam(value="pricingName") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/{scopeId}/providers/Microsoft.Security/pricings/{pricingName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PricingInner>> update(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="scopeId", encoded=true) String var3, @PathParam(value="pricingName") String var4, @BodyParam(value="application/json") PricingInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/{scopeId}/providers/Microsoft.Security/pricings/{pricingName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="scopeId", encoded=true) String var3, @PathParam(value="pricingName") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{scopeId}/providers/Microsoft.Security/pricings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PricingListInner>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="scopeId", encoded=true) String var3, @QueryParam(value="$filter") String var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

