/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.PricingsClient;
import com.azure.resourcemanager.security.fluent.models.PricingInner;
import com.azure.resourcemanager.security.fluent.models.PricingListInner;
import com.azure.resourcemanager.security.implementation.PricingImpl;
import com.azure.resourcemanager.security.implementation.PricingListImpl;
import com.azure.resourcemanager.security.models.Pricing;
import com.azure.resourcemanager.security.models.PricingList;
import com.azure.resourcemanager.security.models.Pricings;

public final class PricingsImpl
implements Pricings {
    private static final ClientLogger LOGGER = new ClientLogger(PricingsImpl.class);
    private final PricingsClient innerClient;
    private final SecurityManager serviceManager;

    public PricingsImpl(PricingsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Pricing> getWithResponse(String scopeId, String pricingName, Context context) {
        Response<PricingInner> inner = this.serviceClient().getWithResponse(scopeId, pricingName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PricingImpl((PricingInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Pricing get(String scopeId, String pricingName) {
        PricingInner inner = this.serviceClient().get(scopeId, pricingName);
        if (inner != null) {
            return new PricingImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Pricing> updateWithResponse(String scopeId, String pricingName, PricingInner pricing, Context context) {
        Response<PricingInner> inner = this.serviceClient().updateWithResponse(scopeId, pricingName, pricing, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PricingImpl((PricingInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Pricing update(String scopeId, String pricingName, PricingInner pricing) {
        PricingInner inner = this.serviceClient().update(scopeId, pricingName, pricing);
        if (inner != null) {
            return new PricingImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteByResourceGroupWithResponse(String scopeId, String pricingName, Context context) {
        return this.serviceClient().deleteWithResponse(scopeId, pricingName, context);
    }

    @Override
    public void deleteByResourceGroup(String scopeId, String pricingName) {
        this.serviceClient().delete(scopeId, pricingName);
    }

    @Override
    public Response<PricingList> listWithResponse(String scopeId, String filter, Context context) {
        Response<PricingListInner> inner = this.serviceClient().listWithResponse(scopeId, filter, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PricingListImpl((PricingListInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PricingList list(String scopeId) {
        PricingListInner inner = this.serviceClient().list(scopeId);
        if (inner != null) {
            return new PricingListImpl(inner, this.manager());
        }
        return null;
    }

    private PricingsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

