/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.RegulatoryComplianceAssessmentsClient;
import com.azure.resourcemanager.security.fluent.models.RegulatoryComplianceAssessmentInner;
import com.azure.resourcemanager.security.implementation.RegulatoryComplianceAssessmentImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.RegulatoryComplianceAssessment;
import com.azure.resourcemanager.security.models.RegulatoryComplianceAssessments;

public final class RegulatoryComplianceAssessmentsImpl
implements RegulatoryComplianceAssessments {
    private static final ClientLogger LOGGER = new ClientLogger(RegulatoryComplianceAssessmentsImpl.class);
    private final RegulatoryComplianceAssessmentsClient innerClient;
    private final SecurityManager serviceManager;

    public RegulatoryComplianceAssessmentsImpl(RegulatoryComplianceAssessmentsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<RegulatoryComplianceAssessment> list(String regulatoryComplianceStandardName, String regulatoryComplianceControlName) {
        PagedIterable<RegulatoryComplianceAssessmentInner> inner = this.serviceClient().list(regulatoryComplianceStandardName, regulatoryComplianceControlName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RegulatoryComplianceAssessmentImpl((RegulatoryComplianceAssessmentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<RegulatoryComplianceAssessment> list(String regulatoryComplianceStandardName, String regulatoryComplianceControlName, String filter, Context context) {
        PagedIterable<RegulatoryComplianceAssessmentInner> inner = this.serviceClient().list(regulatoryComplianceStandardName, regulatoryComplianceControlName, filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RegulatoryComplianceAssessmentImpl((RegulatoryComplianceAssessmentInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<RegulatoryComplianceAssessment> getWithResponse(String regulatoryComplianceStandardName, String regulatoryComplianceControlName, String regulatoryComplianceAssessmentName, Context context) {
        Response<RegulatoryComplianceAssessmentInner> inner = this.serviceClient().getWithResponse(regulatoryComplianceStandardName, regulatoryComplianceControlName, regulatoryComplianceAssessmentName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RegulatoryComplianceAssessmentImpl((RegulatoryComplianceAssessmentInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public RegulatoryComplianceAssessment get(String regulatoryComplianceStandardName, String regulatoryComplianceControlName, String regulatoryComplianceAssessmentName) {
        RegulatoryComplianceAssessmentInner inner = this.serviceClient().get(regulatoryComplianceStandardName, regulatoryComplianceControlName, regulatoryComplianceAssessmentName);
        if (inner != null) {
            return new RegulatoryComplianceAssessmentImpl(inner, this.manager());
        }
        return null;
    }

    private RegulatoryComplianceAssessmentsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

