/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.security.fluent.RegulatoryComplianceControlsClient;
import com.azure.resourcemanager.security.fluent.models.RegulatoryComplianceControlInner;
import com.azure.resourcemanager.security.implementation.SecurityCenterImpl;
import com.azure.resourcemanager.security.models.RegulatoryComplianceControlList;
import reactor.core.publisher.Mono;

public final class RegulatoryComplianceControlsClientImpl
implements RegulatoryComplianceControlsClient {
    private final RegulatoryComplianceControlsService service;
    private final SecurityCenterImpl client;

    RegulatoryComplianceControlsClientImpl(SecurityCenterImpl client) {
        this.service = (RegulatoryComplianceControlsService)RestProxy.create(RegulatoryComplianceControlsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RegulatoryComplianceControlInner>> listSinglePageAsync(String regulatoryComplianceStandardName, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (regulatoryComplianceStandardName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter regulatoryComplianceStandardName is required and cannot be null."));
        }
        String apiVersion = "2019-01-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2019-01-01-preview", this.client.getSubscriptionId(), regulatoryComplianceStandardName, filter, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RegulatoryComplianceControlList)res.getValue()).value(), ((RegulatoryComplianceControlList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RegulatoryComplianceControlInner>> listSinglePageAsync(String regulatoryComplianceStandardName, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (regulatoryComplianceStandardName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter regulatoryComplianceStandardName is required and cannot be null."));
        }
        String apiVersion = "2019-01-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2019-01-01-preview", this.client.getSubscriptionId(), regulatoryComplianceStandardName, filter, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RegulatoryComplianceControlList)res.getValue()).value(), ((RegulatoryComplianceControlList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RegulatoryComplianceControlInner> listAsync(String regulatoryComplianceStandardName, String filter) {
        return new PagedFlux(() -> this.listSinglePageAsync(regulatoryComplianceStandardName, filter), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RegulatoryComplianceControlInner> listAsync(String regulatoryComplianceStandardName) {
        String filter = null;
        return new PagedFlux(() -> this.listSinglePageAsync(regulatoryComplianceStandardName, filter), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RegulatoryComplianceControlInner> listAsync(String regulatoryComplianceStandardName, String filter, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(regulatoryComplianceStandardName, filter, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RegulatoryComplianceControlInner> list(String regulatoryComplianceStandardName) {
        String filter = null;
        return new PagedIterable(this.listAsync(regulatoryComplianceStandardName, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RegulatoryComplianceControlInner> list(String regulatoryComplianceStandardName, String filter, Context context) {
        return new PagedIterable(this.listAsync(regulatoryComplianceStandardName, filter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RegulatoryComplianceControlInner>> getWithResponseAsync(String regulatoryComplianceStandardName, String regulatoryComplianceControlName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (regulatoryComplianceStandardName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter regulatoryComplianceStandardName is required and cannot be null."));
        }
        if (regulatoryComplianceControlName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter regulatoryComplianceControlName is required and cannot be null."));
        }
        String apiVersion = "2019-01-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2019-01-01-preview", this.client.getSubscriptionId(), regulatoryComplianceStandardName, regulatoryComplianceControlName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RegulatoryComplianceControlInner>> getWithResponseAsync(String regulatoryComplianceStandardName, String regulatoryComplianceControlName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (regulatoryComplianceStandardName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter regulatoryComplianceStandardName is required and cannot be null."));
        }
        if (regulatoryComplianceControlName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter regulatoryComplianceControlName is required and cannot be null."));
        }
        String apiVersion = "2019-01-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), "2019-01-01-preview", this.client.getSubscriptionId(), regulatoryComplianceStandardName, regulatoryComplianceControlName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RegulatoryComplianceControlInner> getAsync(String regulatoryComplianceStandardName, String regulatoryComplianceControlName) {
        return this.getWithResponseAsync(regulatoryComplianceStandardName, regulatoryComplianceControlName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RegulatoryComplianceControlInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RegulatoryComplianceControlInner> getWithResponse(String regulatoryComplianceStandardName, String regulatoryComplianceControlName, Context context) {
        return (Response)this.getWithResponseAsync(regulatoryComplianceStandardName, regulatoryComplianceControlName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RegulatoryComplianceControlInner get(String regulatoryComplianceStandardName, String regulatoryComplianceControlName) {
        return (RegulatoryComplianceControlInner)((Object)this.getWithResponse(regulatoryComplianceStandardName, regulatoryComplianceControlName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RegulatoryComplianceControlInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RegulatoryComplianceControlList)res.getValue()).value(), ((RegulatoryComplianceControlList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RegulatoryComplianceControlInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RegulatoryComplianceControlList)res.getValue()).value(), ((RegulatoryComplianceControlList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SecurityCenterRegula")
    public static interface RegulatoryComplianceControlsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/regulatoryComplianceStandards/{regulatoryComplianceStandardName}/regulatoryComplianceControls")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RegulatoryComplianceControlList>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="regulatoryComplianceStandardName") String var4, @QueryParam(value="$filter") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/regulatoryComplianceStandards/{regulatoryComplianceStandardName}/regulatoryComplianceControls/{regulatoryComplianceControlName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RegulatoryComplianceControlInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="regulatoryComplianceStandardName") String var4, @PathParam(value="regulatoryComplianceControlName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RegulatoryComplianceControlList>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

