/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.RegulatoryComplianceStandardsClient;
import com.azure.resourcemanager.security.fluent.models.RegulatoryComplianceStandardInner;
import com.azure.resourcemanager.security.implementation.RegulatoryComplianceStandardImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.RegulatoryComplianceStandard;
import com.azure.resourcemanager.security.models.RegulatoryComplianceStandards;

public final class RegulatoryComplianceStandardsImpl
implements RegulatoryComplianceStandards {
    private static final ClientLogger LOGGER = new ClientLogger(RegulatoryComplianceStandardsImpl.class);
    private final RegulatoryComplianceStandardsClient innerClient;
    private final SecurityManager serviceManager;

    public RegulatoryComplianceStandardsImpl(RegulatoryComplianceStandardsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<RegulatoryComplianceStandard> list() {
        PagedIterable<RegulatoryComplianceStandardInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RegulatoryComplianceStandardImpl((RegulatoryComplianceStandardInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<RegulatoryComplianceStandard> list(String filter, Context context) {
        PagedIterable<RegulatoryComplianceStandardInner> inner = this.serviceClient().list(filter, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RegulatoryComplianceStandardImpl((RegulatoryComplianceStandardInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<RegulatoryComplianceStandard> getWithResponse(String regulatoryComplianceStandardName, Context context) {
        Response<RegulatoryComplianceStandardInner> inner = this.serviceClient().getWithResponse(regulatoryComplianceStandardName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RegulatoryComplianceStandardImpl((RegulatoryComplianceStandardInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public RegulatoryComplianceStandard get(String regulatoryComplianceStandardName) {
        RegulatoryComplianceStandardInner inner = this.serviceClient().get(regulatoryComplianceStandardName);
        if (inner != null) {
            return new RegulatoryComplianceStandardImpl(inner, this.manager());
        }
        return null;
    }

    private RegulatoryComplianceStandardsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

