/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.security.fluent.models.GetSensitivitySettingsResponseInner;
import com.azure.resourcemanager.security.implementation.GetSensitivitySettingsResponseImpl;
import com.azure.resourcemanager.security.models.GetSensitivitySettingsResponse;
import com.azure.resourcemanager.security.models.ResourceProviders;
import com.azure.resourcemanager.security.models.UpdateSensitivitySettingsRequest;

public final class ResourceProvidersImpl
implements ResourceProviders {
    private static final ClientLogger LOGGER = new ClientLogger(ResourceProvidersImpl.class);
    private final ResourceProvidersClient innerClient;
    private final SecurityManager serviceManager;

    public ResourceProvidersImpl(ResourceProvidersClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<GetSensitivitySettingsResponse> updateSensitivitySettingsWithResponse(UpdateSensitivitySettingsRequest sensitivitySettings, Context context) {
        Response<GetSensitivitySettingsResponseInner> inner = this.serviceClient().updateSensitivitySettingsWithResponse(sensitivitySettings, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new GetSensitivitySettingsResponseImpl((GetSensitivitySettingsResponseInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public GetSensitivitySettingsResponse updateSensitivitySettings(UpdateSensitivitySettingsRequest sensitivitySettings) {
        GetSensitivitySettingsResponseInner inner = this.serviceClient().updateSensitivitySettings(sensitivitySettings);
        if (inner != null) {
            return new GetSensitivitySettingsResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<GetSensitivitySettingsResponse> getSensitivitySettingsWithResponse(Context context) {
        Response<GetSensitivitySettingsResponseInner> inner = this.serviceClient().getSensitivitySettingsWithResponse(context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new GetSensitivitySettingsResponseImpl((GetSensitivitySettingsResponseInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public GetSensitivitySettingsResponse getSensitivitySettings() {
        GetSensitivitySettingsResponseInner inner = this.serviceClient().getSensitivitySettings();
        if (inner != null) {
            return new GetSensitivitySettingsResponseImpl(inner, this.manager());
        }
        return null;
    }

    private ResourceProvidersClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

