/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.SecureScoreControlsClient;
import com.azure.resourcemanager.security.fluent.models.SecureScoreControlDetailsInner;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.implementation.SecureScoreControlDetailsImpl;
import com.azure.resourcemanager.security.models.ExpandControlsEnum;
import com.azure.resourcemanager.security.models.SecureScoreControlDetails;
import com.azure.resourcemanager.security.models.SecureScoreControls;

public final class SecureScoreControlsImpl
implements SecureScoreControls {
    private static final ClientLogger LOGGER = new ClientLogger(SecureScoreControlsImpl.class);
    private final SecureScoreControlsClient innerClient;
    private final SecurityManager serviceManager;

    public SecureScoreControlsImpl(SecureScoreControlsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<SecureScoreControlDetails> listBySecureScore(String secureScoreName) {
        PagedIterable<SecureScoreControlDetailsInner> inner = this.serviceClient().listBySecureScore(secureScoreName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SecureScoreControlDetailsImpl((SecureScoreControlDetailsInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SecureScoreControlDetails> listBySecureScore(String secureScoreName, ExpandControlsEnum expand, Context context) {
        PagedIterable<SecureScoreControlDetailsInner> inner = this.serviceClient().listBySecureScore(secureScoreName, expand, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SecureScoreControlDetailsImpl((SecureScoreControlDetailsInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SecureScoreControlDetails> list() {
        PagedIterable<SecureScoreControlDetailsInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SecureScoreControlDetailsImpl((SecureScoreControlDetailsInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SecureScoreControlDetails> list(ExpandControlsEnum expand, Context context) {
        PagedIterable<SecureScoreControlDetailsInner> inner = this.serviceClient().list(expand, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SecureScoreControlDetailsImpl((SecureScoreControlDetailsInner)((Object)inner1), this.manager()));
    }

    private SecureScoreControlsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

