/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.SecureScoresClient;
import com.azure.resourcemanager.security.fluent.models.SecureScoreItemInner;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.implementation.SecureScoreItemImpl;
import com.azure.resourcemanager.security.models.SecureScoreItem;
import com.azure.resourcemanager.security.models.SecureScores;

public final class SecureScoresImpl
implements SecureScores {
    private static final ClientLogger LOGGER = new ClientLogger(SecureScoresImpl.class);
    private final SecureScoresClient innerClient;
    private final SecurityManager serviceManager;

    public SecureScoresImpl(SecureScoresClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<SecureScoreItem> list() {
        PagedIterable<SecureScoreItemInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SecureScoreItemImpl((SecureScoreItemInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SecureScoreItem> list(Context context) {
        PagedIterable<SecureScoreItemInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SecureScoreItemImpl((SecureScoreItemInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<SecureScoreItem> getWithResponse(String secureScoreName, Context context) {
        Response<SecureScoreItemInner> inner = this.serviceClient().getWithResponse(secureScoreName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SecureScoreItemImpl((SecureScoreItemInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SecureScoreItem get(String secureScoreName) {
        SecureScoreItemInner inner = this.serviceClient().get(secureScoreName);
        if (inner != null) {
            return new SecureScoreItemImpl(inner, this.manager());
        }
        return null;
    }

    private SecureScoresClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

