/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.models.SecurityAssessmentMetadataProperties;
import com.azure.resourcemanager.security.fluent.models.SecurityAssessmentResponseInner;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.AssessmentLinks;
import com.azure.resourcemanager.security.models.AssessmentStatus;
import com.azure.resourcemanager.security.models.AssessmentStatusResponse;
import com.azure.resourcemanager.security.models.ExpandEnum;
import com.azure.resourcemanager.security.models.ResourceDetails;
import com.azure.resourcemanager.security.models.SecurityAssessment;
import com.azure.resourcemanager.security.models.SecurityAssessmentPartnerData;
import com.azure.resourcemanager.security.models.SecurityAssessmentResponse;
import java.util.Collections;
import java.util.Map;

public final class SecurityAssessmentResponseImpl
implements SecurityAssessmentResponse,
SecurityAssessmentResponse.Definition,
SecurityAssessmentResponse.Update {
    private SecurityAssessmentResponseInner innerObject;
    private final SecurityManager serviceManager;
    private String resourceId;
    private String assessmentName;
    private SecurityAssessment createAssessment;
    private SecurityAssessment updateAssessment;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public AssessmentStatusResponse status() {
        return this.innerModel().status();
    }

    @Override
    public ResourceDetails resourceDetails() {
        return this.innerModel().resourceDetails();
    }

    @Override
    public String displayName() {
        return this.innerModel().displayName();
    }

    @Override
    public Map<String, String> additionalData() {
        Map<String, String> inner = this.innerModel().additionalData();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public AssessmentLinks links() {
        return this.innerModel().links();
    }

    @Override
    public SecurityAssessmentMetadataProperties metadata() {
        return this.innerModel().metadata();
    }

    @Override
    public SecurityAssessmentPartnerData partnersData() {
        return this.innerModel().partnersData();
    }

    @Override
    public SecurityAssessmentResponseInner innerModel() {
        return this.innerObject;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public SecurityAssessmentResponseImpl withExistingResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    @Override
    public SecurityAssessmentResponse create() {
        this.innerObject = (SecurityAssessmentResponseInner)((Object)this.serviceManager.serviceClient().getAssessments().createOrUpdateWithResponse(this.resourceId, this.assessmentName, this.createAssessment, Context.NONE).getValue());
        return this;
    }

    @Override
    public SecurityAssessmentResponse create(Context context) {
        this.innerObject = (SecurityAssessmentResponseInner)((Object)this.serviceManager.serviceClient().getAssessments().createOrUpdateWithResponse(this.resourceId, this.assessmentName, this.createAssessment, context).getValue());
        return this;
    }

    SecurityAssessmentResponseImpl(String name, SecurityManager serviceManager) {
        this.innerObject = new SecurityAssessmentResponseInner();
        this.serviceManager = serviceManager;
        this.assessmentName = name;
        this.createAssessment = new SecurityAssessment();
    }

    @Override
    public SecurityAssessmentResponseImpl update() {
        this.updateAssessment = new SecurityAssessment();
        return this;
    }

    @Override
    public SecurityAssessmentResponse apply() {
        this.innerObject = (SecurityAssessmentResponseInner)((Object)this.serviceManager.serviceClient().getAssessments().createOrUpdateWithResponse(this.resourceId, this.assessmentName, this.updateAssessment, Context.NONE).getValue());
        return this;
    }

    @Override
    public SecurityAssessmentResponse apply(Context context) {
        this.innerObject = (SecurityAssessmentResponseInner)((Object)this.serviceManager.serviceClient().getAssessments().createOrUpdateWithResponse(this.resourceId, this.assessmentName, this.updateAssessment, context).getValue());
        return this;
    }

    SecurityAssessmentResponseImpl(SecurityAssessmentResponseInner innerObject, SecurityManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceId = ResourceManagerUtils.getValueFromIdByParameterName(innerObject.id(), "/{resourceId}/providers/Microsoft.Security/assessments/{assessmentName}", "resourceId");
        this.assessmentName = ResourceManagerUtils.getValueFromIdByParameterName(innerObject.id(), "/{resourceId}/providers/Microsoft.Security/assessments/{assessmentName}", "assessmentName");
    }

    @Override
    public SecurityAssessmentResponse refresh() {
        ExpandEnum localExpand = null;
        this.innerObject = (SecurityAssessmentResponseInner)((Object)this.serviceManager.serviceClient().getAssessments().getWithResponse(this.resourceId, this.assessmentName, localExpand, Context.NONE).getValue());
        return this;
    }

    @Override
    public SecurityAssessmentResponse refresh(Context context) {
        ExpandEnum localExpand = null;
        this.innerObject = (SecurityAssessmentResponseInner)((Object)this.serviceManager.serviceClient().getAssessments().getWithResponse(this.resourceId, this.assessmentName, localExpand, context).getValue());
        return this;
    }

    @Override
    public SecurityAssessmentResponseImpl withStatus(AssessmentStatus status) {
        if (this.isInCreateMode()) {
            this.createAssessment.withStatus(status);
            return this;
        }
        this.updateAssessment.withStatus(status);
        return this;
    }

    @Override
    public SecurityAssessmentResponseImpl withResourceDetails(ResourceDetails resourceDetails) {
        if (this.isInCreateMode()) {
            this.createAssessment.withResourceDetails(resourceDetails);
            return this;
        }
        this.updateAssessment.withResourceDetails(resourceDetails);
        return this;
    }

    @Override
    public SecurityAssessmentResponseImpl withAdditionalData(Map<String, String> additionalData) {
        if (this.isInCreateMode()) {
            this.createAssessment.withAdditionalData(additionalData);
            return this;
        }
        this.updateAssessment.withAdditionalData(additionalData);
        return this;
    }

    @Override
    public SecurityAssessmentResponseImpl withMetadata(SecurityAssessmentMetadataProperties metadata) {
        if (this.isInCreateMode()) {
            this.createAssessment.withMetadata(metadata);
            return this;
        }
        this.updateAssessment.withMetadata(metadata);
        return this;
    }

    @Override
    public SecurityAssessmentResponseImpl withPartnersData(SecurityAssessmentPartnerData partnersData) {
        if (this.isInCreateMode()) {
            this.createAssessment.withPartnersData(partnersData);
            return this;
        }
        this.updateAssessment.withPartnersData(partnersData);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

