/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.security.fluent.AdaptiveApplicationControlsClient;
import com.azure.resourcemanager.security.fluent.AdaptiveNetworkHardeningsClient;
import com.azure.resourcemanager.security.fluent.AdvancedThreatProtectionsClient;
import com.azure.resourcemanager.security.fluent.AlertsClient;
import com.azure.resourcemanager.security.fluent.AlertsSuppressionRulesClient;
import com.azure.resourcemanager.security.fluent.AllowedConnectionsClient;
import com.azure.resourcemanager.security.fluent.ApiCollectionsClient;
import com.azure.resourcemanager.security.fluent.ApplicationOperationsClient;
import com.azure.resourcemanager.security.fluent.ApplicationsClient;
import com.azure.resourcemanager.security.fluent.AssessmentsClient;
import com.azure.resourcemanager.security.fluent.AssessmentsMetadatasClient;
import com.azure.resourcemanager.security.fluent.AutoProvisioningSettingsClient;
import com.azure.resourcemanager.security.fluent.AutomationsClient;
import com.azure.resourcemanager.security.fluent.AzureDevOpsOrgsClient;
import com.azure.resourcemanager.security.fluent.AzureDevOpsProjectsClient;
import com.azure.resourcemanager.security.fluent.AzureDevOpsReposClient;
import com.azure.resourcemanager.security.fluent.ComplianceResultsClient;
import com.azure.resourcemanager.security.fluent.CompliancesClient;
import com.azure.resourcemanager.security.fluent.ConnectorsClient;
import com.azure.resourcemanager.security.fluent.CustomAssessmentAutomationsClient;
import com.azure.resourcemanager.security.fluent.CustomEntityStoreAssignmentsClient;
import com.azure.resourcemanager.security.fluent.DefenderForStoragesClient;
import com.azure.resourcemanager.security.fluent.DevOpsConfigurationsClient;
import com.azure.resourcemanager.security.fluent.DevOpsOperationResultsClient;
import com.azure.resourcemanager.security.fluent.DeviceSecurityGroupsClient;
import com.azure.resourcemanager.security.fluent.DiscoveredSecuritySolutionsClient;
import com.azure.resourcemanager.security.fluent.ExternalSecuritySolutionsClient;
import com.azure.resourcemanager.security.fluent.GitHubOwnersClient;
import com.azure.resourcemanager.security.fluent.GitHubReposClient;
import com.azure.resourcemanager.security.fluent.GitLabGroupsClient;
import com.azure.resourcemanager.security.fluent.GitLabProjectsClient;
import com.azure.resourcemanager.security.fluent.GitLabSubgroupsClient;
import com.azure.resourcemanager.security.fluent.GovernanceAssignmentsClient;
import com.azure.resourcemanager.security.fluent.GovernanceRulesClient;
import com.azure.resourcemanager.security.fluent.HealthReportsClient;
import com.azure.resourcemanager.security.fluent.InformationProtectionPoliciesClient;
import com.azure.resourcemanager.security.fluent.IotSecuritySolutionAnalyticsClient;
import com.azure.resourcemanager.security.fluent.IotSecuritySolutionsAnalyticsAggregatedAlertsClient;
import com.azure.resourcemanager.security.fluent.IotSecuritySolutionsAnalyticsRecommendationsClient;
import com.azure.resourcemanager.security.fluent.IotSecuritySolutionsClient;
import com.azure.resourcemanager.security.fluent.JitNetworkAccessPoliciesClient;
import com.azure.resourcemanager.security.fluent.LocationsClient;
import com.azure.resourcemanager.security.fluent.MdeOnboardingsClient;
import com.azure.resourcemanager.security.fluent.OperationsClient;
import com.azure.resourcemanager.security.fluent.PricingsClient;
import com.azure.resourcemanager.security.fluent.RegulatoryComplianceAssessmentsClient;
import com.azure.resourcemanager.security.fluent.RegulatoryComplianceControlsClient;
import com.azure.resourcemanager.security.fluent.RegulatoryComplianceStandardsClient;
import com.azure.resourcemanager.security.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.security.fluent.SecureScoreControlDefinitionsClient;
import com.azure.resourcemanager.security.fluent.SecureScoreControlsClient;
import com.azure.resourcemanager.security.fluent.SecureScoresClient;
import com.azure.resourcemanager.security.fluent.SecurityCenter;
import com.azure.resourcemanager.security.fluent.SecurityConnectorApplicationOperationsClient;
import com.azure.resourcemanager.security.fluent.SecurityConnectorApplicationsClient;
import com.azure.resourcemanager.security.fluent.SecurityConnectorsClient;
import com.azure.resourcemanager.security.fluent.SecurityContactsClient;
import com.azure.resourcemanager.security.fluent.SecurityOperatorsClient;
import com.azure.resourcemanager.security.fluent.SecuritySolutionsClient;
import com.azure.resourcemanager.security.fluent.SecuritySolutionsReferenceDatasClient;
import com.azure.resourcemanager.security.fluent.SensitivitySettingsClient;
import com.azure.resourcemanager.security.fluent.ServerVulnerabilityAssessmentsClient;
import com.azure.resourcemanager.security.fluent.ServerVulnerabilityAssessmentsSettingsClient;
import com.azure.resourcemanager.security.fluent.SettingsClient;
import com.azure.resourcemanager.security.fluent.SoftwareInventoriesClient;
import com.azure.resourcemanager.security.fluent.SqlVulnerabilityAssessmentBaselineRulesClient;
import com.azure.resourcemanager.security.fluent.SqlVulnerabilityAssessmentScanResultsClient;
import com.azure.resourcemanager.security.fluent.SqlVulnerabilityAssessmentScansClient;
import com.azure.resourcemanager.security.fluent.SubAssessmentsClient;
import com.azure.resourcemanager.security.fluent.TasksClient;
import com.azure.resourcemanager.security.fluent.TopologiesClient;
import com.azure.resourcemanager.security.fluent.WorkspaceSettingsClient;
import com.azure.resourcemanager.security.implementation.AdaptiveApplicationControlsClientImpl;
import com.azure.resourcemanager.security.implementation.AdaptiveNetworkHardeningsClientImpl;
import com.azure.resourcemanager.security.implementation.AdvancedThreatProtectionsClientImpl;
import com.azure.resourcemanager.security.implementation.AlertsClientImpl;
import com.azure.resourcemanager.security.implementation.AlertsSuppressionRulesClientImpl;
import com.azure.resourcemanager.security.implementation.AllowedConnectionsClientImpl;
import com.azure.resourcemanager.security.implementation.ApiCollectionsClientImpl;
import com.azure.resourcemanager.security.implementation.ApplicationOperationsClientImpl;
import com.azure.resourcemanager.security.implementation.ApplicationsClientImpl;
import com.azure.resourcemanager.security.implementation.AssessmentsClientImpl;
import com.azure.resourcemanager.security.implementation.AssessmentsMetadatasClientImpl;
import com.azure.resourcemanager.security.implementation.AutoProvisioningSettingsClientImpl;
import com.azure.resourcemanager.security.implementation.AutomationsClientImpl;
import com.azure.resourcemanager.security.implementation.AzureDevOpsOrgsClientImpl;
import com.azure.resourcemanager.security.implementation.AzureDevOpsProjectsClientImpl;
import com.azure.resourcemanager.security.implementation.AzureDevOpsReposClientImpl;
import com.azure.resourcemanager.security.implementation.ComplianceResultsClientImpl;
import com.azure.resourcemanager.security.implementation.CompliancesClientImpl;
import com.azure.resourcemanager.security.implementation.ConnectorsClientImpl;
import com.azure.resourcemanager.security.implementation.CustomAssessmentAutomationsClientImpl;
import com.azure.resourcemanager.security.implementation.CustomEntityStoreAssignmentsClientImpl;
import com.azure.resourcemanager.security.implementation.DefenderForStoragesClientImpl;
import com.azure.resourcemanager.security.implementation.DevOpsConfigurationsClientImpl;
import com.azure.resourcemanager.security.implementation.DevOpsOperationResultsClientImpl;
import com.azure.resourcemanager.security.implementation.DeviceSecurityGroupsClientImpl;
import com.azure.resourcemanager.security.implementation.DiscoveredSecuritySolutionsClientImpl;
import com.azure.resourcemanager.security.implementation.ExternalSecuritySolutionsClientImpl;
import com.azure.resourcemanager.security.implementation.GitHubOwnersClientImpl;
import com.azure.resourcemanager.security.implementation.GitHubReposClientImpl;
import com.azure.resourcemanager.security.implementation.GitLabGroupsClientImpl;
import com.azure.resourcemanager.security.implementation.GitLabProjectsClientImpl;
import com.azure.resourcemanager.security.implementation.GitLabSubgroupsClientImpl;
import com.azure.resourcemanager.security.implementation.GovernanceAssignmentsClientImpl;
import com.azure.resourcemanager.security.implementation.GovernanceRulesClientImpl;
import com.azure.resourcemanager.security.implementation.HealthReportsClientImpl;
import com.azure.resourcemanager.security.implementation.InformationProtectionPoliciesClientImpl;
import com.azure.resourcemanager.security.implementation.IotSecuritySolutionAnalyticsClientImpl;
import com.azure.resourcemanager.security.implementation.IotSecuritySolutionsAnalyticsAggregatedAlertsClientImpl;
import com.azure.resourcemanager.security.implementation.IotSecuritySolutionsAnalyticsRecommendationsClientImpl;
import com.azure.resourcemanager.security.implementation.IotSecuritySolutionsClientImpl;
import com.azure.resourcemanager.security.implementation.JitNetworkAccessPoliciesClientImpl;
import com.azure.resourcemanager.security.implementation.LocationsClientImpl;
import com.azure.resourcemanager.security.implementation.MdeOnboardingsClientImpl;
import com.azure.resourcemanager.security.implementation.OperationsClientImpl;
import com.azure.resourcemanager.security.implementation.PricingsClientImpl;
import com.azure.resourcemanager.security.implementation.RegulatoryComplianceAssessmentsClientImpl;
import com.azure.resourcemanager.security.implementation.RegulatoryComplianceControlsClientImpl;
import com.azure.resourcemanager.security.implementation.RegulatoryComplianceStandardsClientImpl;
import com.azure.resourcemanager.security.implementation.ResourceProvidersClientImpl;
import com.azure.resourcemanager.security.implementation.SecureScoreControlDefinitionsClientImpl;
import com.azure.resourcemanager.security.implementation.SecureScoreControlsClientImpl;
import com.azure.resourcemanager.security.implementation.SecureScoresClientImpl;
import com.azure.resourcemanager.security.implementation.SecurityCenterBuilder;
import com.azure.resourcemanager.security.implementation.SecurityConnectorApplicationOperationsClientImpl;
import com.azure.resourcemanager.security.implementation.SecurityConnectorApplicationsClientImpl;
import com.azure.resourcemanager.security.implementation.SecurityConnectorsClientImpl;
import com.azure.resourcemanager.security.implementation.SecurityContactsClientImpl;
import com.azure.resourcemanager.security.implementation.SecurityOperatorsClientImpl;
import com.azure.resourcemanager.security.implementation.SecuritySolutionsClientImpl;
import com.azure.resourcemanager.security.implementation.SecuritySolutionsReferenceDatasClientImpl;
import com.azure.resourcemanager.security.implementation.SensitivitySettingsClientImpl;
import com.azure.resourcemanager.security.implementation.ServerVulnerabilityAssessmentsClientImpl;
import com.azure.resourcemanager.security.implementation.ServerVulnerabilityAssessmentsSettingsClientImpl;
import com.azure.resourcemanager.security.implementation.SettingsClientImpl;
import com.azure.resourcemanager.security.implementation.SoftwareInventoriesClientImpl;
import com.azure.resourcemanager.security.implementation.SqlVulnerabilityAssessmentBaselineRulesClientImpl;
import com.azure.resourcemanager.security.implementation.SqlVulnerabilityAssessmentScanResultsClientImpl;
import com.azure.resourcemanager.security.implementation.SqlVulnerabilityAssessmentScansClientImpl;
import com.azure.resourcemanager.security.implementation.SubAssessmentsClientImpl;
import com.azure.resourcemanager.security.implementation.TasksClientImpl;
import com.azure.resourcemanager.security.implementation.TopologiesClientImpl;
import com.azure.resourcemanager.security.implementation.WorkspaceSettingsClientImpl;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=SecurityCenterBuilder.class)
public final class SecurityCenterImpl
implements SecurityCenter {
    private final String subscriptionId;
    private final String endpoint;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final LocationsClient locations;
    private final OperationsClient operations;
    private final TasksClient tasks;
    private final AutoProvisioningSettingsClient autoProvisioningSettings;
    private final CompliancesClient compliances;
    private final InformationProtectionPoliciesClient informationProtectionPolicies;
    private final WorkspaceSettingsClient workspaceSettings;
    private final AlertsSuppressionRulesClient alertsSuppressionRules;
    private final AutomationsClient automations;
    private final RegulatoryComplianceStandardsClient regulatoryComplianceStandards;
    private final RegulatoryComplianceControlsClient regulatoryComplianceControls;
    private final RegulatoryComplianceAssessmentsClient regulatoryComplianceAssessments;
    private final SubAssessmentsClient subAssessments;
    private final ConnectorsClient connectors;
    private final SecurityContactsClient securityContacts;
    private final SoftwareInventoriesClient softwareInventories;
    private final CustomAssessmentAutomationsClient customAssessmentAutomations;
    private final CustomEntityStoreAssignmentsClient customEntityStoreAssignments;
    private final MdeOnboardingsClient mdeOnboardings;
    private final GovernanceAssignmentsClient governanceAssignments;
    private final GovernanceRulesClient governanceRules;
    private final ApplicationsClient applications;
    private final ApplicationOperationsClient applicationOperations;
    private final SecurityConnectorApplicationsClient securityConnectorApplications;
    private final SecurityConnectorApplicationOperationsClient securityConnectorApplicationOperations;
    private final DefenderForStoragesClient defenderForStorages;
    private final SecurityOperatorsClient securityOperators;
    private final SqlVulnerabilityAssessmentBaselineRulesClient sqlVulnerabilityAssessmentBaselineRules;
    private final SqlVulnerabilityAssessmentScansClient sqlVulnerabilityAssessmentScans;
    private final SqlVulnerabilityAssessmentScanResultsClient sqlVulnerabilityAssessmentScanResults;
    private final ResourceProvidersClient resourceProviders;
    private final SensitivitySettingsClient sensitivitySettings;
    private final HealthReportsClient healthReports;
    private final AzureDevOpsOrgsClient azureDevOpsOrgs;
    private final AzureDevOpsProjectsClient azureDevOpsProjects;
    private final AzureDevOpsReposClient azureDevOpsRepos;
    private final DevOpsConfigurationsClient devOpsConfigurations;
    private final GitHubOwnersClient gitHubOwners;
    private final GitHubReposClient gitHubRepos;
    private final GitLabGroupsClient gitLabGroups;
    private final GitLabSubgroupsClient gitLabSubgroups;
    private final GitLabProjectsClient gitLabProjects;
    private final DevOpsOperationResultsClient devOpsOperationResults;
    private final SecurityConnectorsClient securityConnectors;
    private final ComplianceResultsClient complianceResults;
    private final AdvancedThreatProtectionsClient advancedThreatProtections;
    private final DeviceSecurityGroupsClient deviceSecurityGroups;
    private final IotSecuritySolutionAnalyticsClient iotSecuritySolutionAnalytics;
    private final IotSecuritySolutionsAnalyticsAggregatedAlertsClient iotSecuritySolutionsAnalyticsAggregatedAlerts;
    private final IotSecuritySolutionsAnalyticsRecommendationsClient iotSecuritySolutionsAnalyticsRecommendations;
    private final IotSecuritySolutionsClient iotSecuritySolutions;
    private final AdaptiveNetworkHardeningsClient adaptiveNetworkHardenings;
    private final AllowedConnectionsClient allowedConnections;
    private final AdaptiveApplicationControlsClient adaptiveApplicationControls;
    private final DiscoveredSecuritySolutionsClient discoveredSecuritySolutions;
    private final ExternalSecuritySolutionsClient externalSecuritySolutions;
    private final JitNetworkAccessPoliciesClient jitNetworkAccessPolicies;
    private final SecureScoresClient secureScores;
    private final SecureScoreControlsClient secureScoreControls;
    private final SecureScoreControlDefinitionsClient secureScoreControlDefinitions;
    private final SecuritySolutionsClient securitySolutions;
    private final SecuritySolutionsReferenceDatasClient securitySolutionsReferenceDatas;
    private final ServerVulnerabilityAssessmentsClient serverVulnerabilityAssessments;
    private final TopologiesClient topologies;
    private final AssessmentsMetadatasClient assessmentsMetadatas;
    private final AssessmentsClient assessments;
    private final AlertsClient alerts;
    private final SettingsClient settings;
    private final ServerVulnerabilityAssessmentsSettingsClient serverVulnerabilityAssessmentsSettings;
    private final ApiCollectionsClient apiCollections;
    private final PricingsClient pricings;
    private static final ClientLogger LOGGER = new ClientLogger(SecurityCenterImpl.class);

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public LocationsClient getLocations() {
        return this.locations;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public TasksClient getTasks() {
        return this.tasks;
    }

    @Override
    public AutoProvisioningSettingsClient getAutoProvisioningSettings() {
        return this.autoProvisioningSettings;
    }

    @Override
    public CompliancesClient getCompliances() {
        return this.compliances;
    }

    @Override
    public InformationProtectionPoliciesClient getInformationProtectionPolicies() {
        return this.informationProtectionPolicies;
    }

    @Override
    public WorkspaceSettingsClient getWorkspaceSettings() {
        return this.workspaceSettings;
    }

    @Override
    public AlertsSuppressionRulesClient getAlertsSuppressionRules() {
        return this.alertsSuppressionRules;
    }

    @Override
    public AutomationsClient getAutomations() {
        return this.automations;
    }

    @Override
    public RegulatoryComplianceStandardsClient getRegulatoryComplianceStandards() {
        return this.regulatoryComplianceStandards;
    }

    @Override
    public RegulatoryComplianceControlsClient getRegulatoryComplianceControls() {
        return this.regulatoryComplianceControls;
    }

    @Override
    public RegulatoryComplianceAssessmentsClient getRegulatoryComplianceAssessments() {
        return this.regulatoryComplianceAssessments;
    }

    @Override
    public SubAssessmentsClient getSubAssessments() {
        return this.subAssessments;
    }

    @Override
    public ConnectorsClient getConnectors() {
        return this.connectors;
    }

    @Override
    public SecurityContactsClient getSecurityContacts() {
        return this.securityContacts;
    }

    @Override
    public SoftwareInventoriesClient getSoftwareInventories() {
        return this.softwareInventories;
    }

    @Override
    public CustomAssessmentAutomationsClient getCustomAssessmentAutomations() {
        return this.customAssessmentAutomations;
    }

    @Override
    public CustomEntityStoreAssignmentsClient getCustomEntityStoreAssignments() {
        return this.customEntityStoreAssignments;
    }

    @Override
    public MdeOnboardingsClient getMdeOnboardings() {
        return this.mdeOnboardings;
    }

    @Override
    public GovernanceAssignmentsClient getGovernanceAssignments() {
        return this.governanceAssignments;
    }

    @Override
    public GovernanceRulesClient getGovernanceRules() {
        return this.governanceRules;
    }

    @Override
    public ApplicationsClient getApplications() {
        return this.applications;
    }

    @Override
    public ApplicationOperationsClient getApplicationOperations() {
        return this.applicationOperations;
    }

    @Override
    public SecurityConnectorApplicationsClient getSecurityConnectorApplications() {
        return this.securityConnectorApplications;
    }

    @Override
    public SecurityConnectorApplicationOperationsClient getSecurityConnectorApplicationOperations() {
        return this.securityConnectorApplicationOperations;
    }

    @Override
    public DefenderForStoragesClient getDefenderForStorages() {
        return this.defenderForStorages;
    }

    @Override
    public SecurityOperatorsClient getSecurityOperators() {
        return this.securityOperators;
    }

    @Override
    public SqlVulnerabilityAssessmentBaselineRulesClient getSqlVulnerabilityAssessmentBaselineRules() {
        return this.sqlVulnerabilityAssessmentBaselineRules;
    }

    @Override
    public SqlVulnerabilityAssessmentScansClient getSqlVulnerabilityAssessmentScans() {
        return this.sqlVulnerabilityAssessmentScans;
    }

    @Override
    public SqlVulnerabilityAssessmentScanResultsClient getSqlVulnerabilityAssessmentScanResults() {
        return this.sqlVulnerabilityAssessmentScanResults;
    }

    @Override
    public ResourceProvidersClient getResourceProviders() {
        return this.resourceProviders;
    }

    @Override
    public SensitivitySettingsClient getSensitivitySettings() {
        return this.sensitivitySettings;
    }

    @Override
    public HealthReportsClient getHealthReports() {
        return this.healthReports;
    }

    @Override
    public AzureDevOpsOrgsClient getAzureDevOpsOrgs() {
        return this.azureDevOpsOrgs;
    }

    @Override
    public AzureDevOpsProjectsClient getAzureDevOpsProjects() {
        return this.azureDevOpsProjects;
    }

    @Override
    public AzureDevOpsReposClient getAzureDevOpsRepos() {
        return this.azureDevOpsRepos;
    }

    @Override
    public DevOpsConfigurationsClient getDevOpsConfigurations() {
        return this.devOpsConfigurations;
    }

    @Override
    public GitHubOwnersClient getGitHubOwners() {
        return this.gitHubOwners;
    }

    @Override
    public GitHubReposClient getGitHubRepos() {
        return this.gitHubRepos;
    }

    @Override
    public GitLabGroupsClient getGitLabGroups() {
        return this.gitLabGroups;
    }

    @Override
    public GitLabSubgroupsClient getGitLabSubgroups() {
        return this.gitLabSubgroups;
    }

    @Override
    public GitLabProjectsClient getGitLabProjects() {
        return this.gitLabProjects;
    }

    @Override
    public DevOpsOperationResultsClient getDevOpsOperationResults() {
        return this.devOpsOperationResults;
    }

    @Override
    public SecurityConnectorsClient getSecurityConnectors() {
        return this.securityConnectors;
    }

    @Override
    public ComplianceResultsClient getComplianceResults() {
        return this.complianceResults;
    }

    @Override
    public AdvancedThreatProtectionsClient getAdvancedThreatProtections() {
        return this.advancedThreatProtections;
    }

    @Override
    public DeviceSecurityGroupsClient getDeviceSecurityGroups() {
        return this.deviceSecurityGroups;
    }

    @Override
    public IotSecuritySolutionAnalyticsClient getIotSecuritySolutionAnalytics() {
        return this.iotSecuritySolutionAnalytics;
    }

    @Override
    public IotSecuritySolutionsAnalyticsAggregatedAlertsClient getIotSecuritySolutionsAnalyticsAggregatedAlerts() {
        return this.iotSecuritySolutionsAnalyticsAggregatedAlerts;
    }

    @Override
    public IotSecuritySolutionsAnalyticsRecommendationsClient getIotSecuritySolutionsAnalyticsRecommendations() {
        return this.iotSecuritySolutionsAnalyticsRecommendations;
    }

    @Override
    public IotSecuritySolutionsClient getIotSecuritySolutions() {
        return this.iotSecuritySolutions;
    }

    @Override
    public AdaptiveNetworkHardeningsClient getAdaptiveNetworkHardenings() {
        return this.adaptiveNetworkHardenings;
    }

    @Override
    public AllowedConnectionsClient getAllowedConnections() {
        return this.allowedConnections;
    }

    @Override
    public AdaptiveApplicationControlsClient getAdaptiveApplicationControls() {
        return this.adaptiveApplicationControls;
    }

    @Override
    public DiscoveredSecuritySolutionsClient getDiscoveredSecuritySolutions() {
        return this.discoveredSecuritySolutions;
    }

    @Override
    public ExternalSecuritySolutionsClient getExternalSecuritySolutions() {
        return this.externalSecuritySolutions;
    }

    @Override
    public JitNetworkAccessPoliciesClient getJitNetworkAccessPolicies() {
        return this.jitNetworkAccessPolicies;
    }

    @Override
    public SecureScoresClient getSecureScores() {
        return this.secureScores;
    }

    @Override
    public SecureScoreControlsClient getSecureScoreControls() {
        return this.secureScoreControls;
    }

    @Override
    public SecureScoreControlDefinitionsClient getSecureScoreControlDefinitions() {
        return this.secureScoreControlDefinitions;
    }

    @Override
    public SecuritySolutionsClient getSecuritySolutions() {
        return this.securitySolutions;
    }

    @Override
    public SecuritySolutionsReferenceDatasClient getSecuritySolutionsReferenceDatas() {
        return this.securitySolutionsReferenceDatas;
    }

    @Override
    public ServerVulnerabilityAssessmentsClient getServerVulnerabilityAssessments() {
        return this.serverVulnerabilityAssessments;
    }

    @Override
    public TopologiesClient getTopologies() {
        return this.topologies;
    }

    @Override
    public AssessmentsMetadatasClient getAssessmentsMetadatas() {
        return this.assessmentsMetadatas;
    }

    @Override
    public AssessmentsClient getAssessments() {
        return this.assessments;
    }

    @Override
    public AlertsClient getAlerts() {
        return this.alerts;
    }

    @Override
    public SettingsClient getSettings() {
        return this.settings;
    }

    @Override
    public ServerVulnerabilityAssessmentsSettingsClient getServerVulnerabilityAssessmentsSettings() {
        return this.serverVulnerabilityAssessmentsSettings;
    }

    @Override
    public ApiCollectionsClient getApiCollections() {
        return this.apiCollections;
    }

    @Override
    public PricingsClient getPricings() {
        return this.pricings;
    }

    SecurityCenterImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.locations = new LocationsClientImpl(this);
        this.operations = new OperationsClientImpl(this);
        this.tasks = new TasksClientImpl(this);
        this.autoProvisioningSettings = new AutoProvisioningSettingsClientImpl(this);
        this.compliances = new CompliancesClientImpl(this);
        this.informationProtectionPolicies = new InformationProtectionPoliciesClientImpl(this);
        this.workspaceSettings = new WorkspaceSettingsClientImpl(this);
        this.alertsSuppressionRules = new AlertsSuppressionRulesClientImpl(this);
        this.automations = new AutomationsClientImpl(this);
        this.regulatoryComplianceStandards = new RegulatoryComplianceStandardsClientImpl(this);
        this.regulatoryComplianceControls = new RegulatoryComplianceControlsClientImpl(this);
        this.regulatoryComplianceAssessments = new RegulatoryComplianceAssessmentsClientImpl(this);
        this.subAssessments = new SubAssessmentsClientImpl(this);
        this.connectors = new ConnectorsClientImpl(this);
        this.securityContacts = new SecurityContactsClientImpl(this);
        this.softwareInventories = new SoftwareInventoriesClientImpl(this);
        this.customAssessmentAutomations = new CustomAssessmentAutomationsClientImpl(this);
        this.customEntityStoreAssignments = new CustomEntityStoreAssignmentsClientImpl(this);
        this.mdeOnboardings = new MdeOnboardingsClientImpl(this);
        this.governanceAssignments = new GovernanceAssignmentsClientImpl(this);
        this.governanceRules = new GovernanceRulesClientImpl(this);
        this.applications = new ApplicationsClientImpl(this);
        this.applicationOperations = new ApplicationOperationsClientImpl(this);
        this.securityConnectorApplications = new SecurityConnectorApplicationsClientImpl(this);
        this.securityConnectorApplicationOperations = new SecurityConnectorApplicationOperationsClientImpl(this);
        this.defenderForStorages = new DefenderForStoragesClientImpl(this);
        this.securityOperators = new SecurityOperatorsClientImpl(this);
        this.sqlVulnerabilityAssessmentBaselineRules = new SqlVulnerabilityAssessmentBaselineRulesClientImpl(this);
        this.sqlVulnerabilityAssessmentScans = new SqlVulnerabilityAssessmentScansClientImpl(this);
        this.sqlVulnerabilityAssessmentScanResults = new SqlVulnerabilityAssessmentScanResultsClientImpl(this);
        this.resourceProviders = new ResourceProvidersClientImpl(this);
        this.sensitivitySettings = new SensitivitySettingsClientImpl(this);
        this.healthReports = new HealthReportsClientImpl(this);
        this.azureDevOpsOrgs = new AzureDevOpsOrgsClientImpl(this);
        this.azureDevOpsProjects = new AzureDevOpsProjectsClientImpl(this);
        this.azureDevOpsRepos = new AzureDevOpsReposClientImpl(this);
        this.devOpsConfigurations = new DevOpsConfigurationsClientImpl(this);
        this.gitHubOwners = new GitHubOwnersClientImpl(this);
        this.gitHubRepos = new GitHubReposClientImpl(this);
        this.gitLabGroups = new GitLabGroupsClientImpl(this);
        this.gitLabSubgroups = new GitLabSubgroupsClientImpl(this);
        this.gitLabProjects = new GitLabProjectsClientImpl(this);
        this.devOpsOperationResults = new DevOpsOperationResultsClientImpl(this);
        this.securityConnectors = new SecurityConnectorsClientImpl(this);
        this.complianceResults = new ComplianceResultsClientImpl(this);
        this.advancedThreatProtections = new AdvancedThreatProtectionsClientImpl(this);
        this.deviceSecurityGroups = new DeviceSecurityGroupsClientImpl(this);
        this.iotSecuritySolutionAnalytics = new IotSecuritySolutionAnalyticsClientImpl(this);
        this.iotSecuritySolutionsAnalyticsAggregatedAlerts = new IotSecuritySolutionsAnalyticsAggregatedAlertsClientImpl(this);
        this.iotSecuritySolutionsAnalyticsRecommendations = new IotSecuritySolutionsAnalyticsRecommendationsClientImpl(this);
        this.iotSecuritySolutions = new IotSecuritySolutionsClientImpl(this);
        this.adaptiveNetworkHardenings = new AdaptiveNetworkHardeningsClientImpl(this);
        this.allowedConnections = new AllowedConnectionsClientImpl(this);
        this.adaptiveApplicationControls = new AdaptiveApplicationControlsClientImpl(this);
        this.discoveredSecuritySolutions = new DiscoveredSecuritySolutionsClientImpl(this);
        this.externalSecuritySolutions = new ExternalSecuritySolutionsClientImpl(this);
        this.jitNetworkAccessPolicies = new JitNetworkAccessPoliciesClientImpl(this);
        this.secureScores = new SecureScoresClientImpl(this);
        this.secureScoreControls = new SecureScoreControlsClientImpl(this);
        this.secureScoreControlDefinitions = new SecureScoreControlDefinitionsClientImpl(this);
        this.securitySolutions = new SecuritySolutionsClientImpl(this);
        this.securitySolutionsReferenceDatas = new SecuritySolutionsReferenceDatasClientImpl(this);
        this.serverVulnerabilityAssessments = new ServerVulnerabilityAssessmentsClientImpl(this);
        this.topologies = new TopologiesClientImpl(this);
        this.assessmentsMetadatas = new AssessmentsMetadatasClientImpl(this);
        this.assessments = new AssessmentsClientImpl(this);
        this.alerts = new AlertsClientImpl(this);
        this.settings = new SettingsClientImpl(this);
        this.serverVulnerabilityAssessmentsSettings = new ServerVulnerabilityAssessmentsSettingsClientImpl(this);
        this.apiCollections = new ApiCollectionsClientImpl(this);
        this.pricings = new PricingsClientImpl(this);
    }

    public Context getContext() {
        return Context.NONE;
    }

    public Context mergeContext(Context context) {
        return CoreUtils.mergeContexts((Context)this.getContext(), (Context)context);
    }

    public <T, U> PollerFlux<PollResult<T>, U> getLroResult(Mono<Response<Flux<ByteBuffer>>> activationResponse, HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Context context) {
        return PollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, activationResponse, (Context)context);
    }

    public <T, U> Mono<U> getLroFinalResultOrError(AsyncPollResponse<PollResult<T>, U> response) {
        if (response.getStatus() != LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String errorMessage;
            ManagementError managementError = null;
            HttpResponseImpl errorResponse = null;
            PollResult.Error lroError = ((PollResult)response.getValue()).getError();
            if (lroError != null) {
                errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(), lroError.getResponseBody());
                errorMessage = ((PollResult)response.getValue()).getError().getMessage();
                String errorBody = ((PollResult)response.getValue()).getError().getResponseBody();
                if (errorBody != null) {
                    try {
                        managementError = (ManagementError)this.getSerializerAdapter().deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                        if (managementError.getCode() == null || managementError.getMessage() == null) {
                            managementError = null;
                        }
                    }
                    catch (IOException | RuntimeException ioe) {
                        LOGGER.logThrowableAsWarning((Throwable)ioe);
                    }
                }
            } else {
                errorMessage = "Long running operation failed.";
            }
            if (managementError == null) {
                managementError = new ManagementError(response.getStatus().toString(), errorMessage);
            }
            return Mono.error((Throwable)new ManagementException(errorMessage, (HttpResponse)errorResponse, managementError));
        }
        return response.getFinalResult();
    }

    private static final class HttpResponseImpl
    extends HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String s) {
            return this.httpHeaders.getValue(s);
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just((Object)ByteBuffer.wrap(this.responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just((Object)this.responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just((Object)new String(this.responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just((Object)new String(this.responseBody, charset));
        }
    }
}

