/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.models.SecurityConnectorInner;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.CloudName;
import com.azure.resourcemanager.security.models.CloudOffering;
import com.azure.resourcemanager.security.models.EnvironmentData;
import com.azure.resourcemanager.security.models.SecurityConnector;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class SecurityConnectorImpl
implements SecurityConnector,
SecurityConnector.Definition,
SecurityConnector.Update {
    private SecurityConnectorInner innerObject;
    private final SecurityManager serviceManager;
    private String resourceGroupName;
    private String securityConnectorName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String hierarchyIdentifier() {
        return this.innerModel().hierarchyIdentifier();
    }

    @Override
    public OffsetDateTime hierarchyIdentifierTrialEndDate() {
        return this.innerModel().hierarchyIdentifierTrialEndDate();
    }

    @Override
    public CloudName environmentName() {
        return this.innerModel().environmentName();
    }

    @Override
    public List<CloudOffering> offerings() {
        List<CloudOffering> inner = this.innerModel().offerings();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public EnvironmentData environmentData() {
        return this.innerModel().environmentData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public SecurityConnectorInner innerModel() {
        return this.innerObject;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public SecurityConnectorImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public SecurityConnector create() {
        this.innerObject = (SecurityConnectorInner)((Object)this.serviceManager.serviceClient().getSecurityConnectors().createOrUpdateWithResponse(this.resourceGroupName, this.securityConnectorName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public SecurityConnector create(Context context) {
        this.innerObject = (SecurityConnectorInner)((Object)this.serviceManager.serviceClient().getSecurityConnectors().createOrUpdateWithResponse(this.resourceGroupName, this.securityConnectorName, this.innerModel(), context).getValue());
        return this;
    }

    SecurityConnectorImpl(String name, SecurityManager serviceManager) {
        this.innerObject = new SecurityConnectorInner();
        this.serviceManager = serviceManager;
        this.securityConnectorName = name;
    }

    @Override
    public SecurityConnectorImpl update() {
        return this;
    }

    @Override
    public SecurityConnector apply() {
        this.innerObject = (SecurityConnectorInner)((Object)this.serviceManager.serviceClient().getSecurityConnectors().updateWithResponse(this.resourceGroupName, this.securityConnectorName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public SecurityConnector apply(Context context) {
        this.innerObject = (SecurityConnectorInner)((Object)this.serviceManager.serviceClient().getSecurityConnectors().updateWithResponse(this.resourceGroupName, this.securityConnectorName, this.innerModel(), context).getValue());
        return this;
    }

    SecurityConnectorImpl(SecurityConnectorInner innerObject, SecurityManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.securityConnectorName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "securityConnectors");
    }

    @Override
    public SecurityConnector refresh() {
        this.innerObject = (SecurityConnectorInner)((Object)this.serviceManager.serviceClient().getSecurityConnectors().getByResourceGroupWithResponse(this.resourceGroupName, this.securityConnectorName, Context.NONE).getValue());
        return this;
    }

    @Override
    public SecurityConnector refresh(Context context) {
        this.innerObject = (SecurityConnectorInner)((Object)this.serviceManager.serviceClient().getSecurityConnectors().getByResourceGroupWithResponse(this.resourceGroupName, this.securityConnectorName, context).getValue());
        return this;
    }

    @Override
    public SecurityConnectorImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public SecurityConnectorImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public SecurityConnectorImpl withTags(Map<String, String> tags) {
        this.innerModel().withTags((Map)tags);
        return this;
    }

    @Override
    public SecurityConnectorImpl withHierarchyIdentifier(String hierarchyIdentifier) {
        this.innerModel().withHierarchyIdentifier(hierarchyIdentifier);
        return this;
    }

    @Override
    public SecurityConnectorImpl withEnvironmentName(CloudName environmentName) {
        this.innerModel().withEnvironmentName(environmentName);
        return this;
    }

    @Override
    public SecurityConnectorImpl withOfferings(List<CloudOffering> offerings) {
        this.innerModel().withOfferings(offerings);
        return this;
    }

    @Override
    public SecurityConnectorImpl withEnvironmentData(EnvironmentData environmentData) {
        this.innerModel().withEnvironmentData(environmentData);
        return this;
    }
}

