/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.SecurityContactsClient;
import com.azure.resourcemanager.security.fluent.models.SecurityContactInner;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.implementation.SecurityContactImpl;
import com.azure.resourcemanager.security.models.SecurityContact;
import com.azure.resourcemanager.security.models.SecurityContactName;
import com.azure.resourcemanager.security.models.SecurityContacts;

public final class SecurityContactsImpl
implements SecurityContacts {
    private static final ClientLogger LOGGER = new ClientLogger(SecurityContactsImpl.class);
    private final SecurityContactsClient innerClient;
    private final SecurityManager serviceManager;

    public SecurityContactsImpl(SecurityContactsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<SecurityContact> list() {
        PagedIterable<SecurityContactInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SecurityContactImpl((SecurityContactInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SecurityContact> list(Context context) {
        PagedIterable<SecurityContactInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SecurityContactImpl((SecurityContactInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<SecurityContact> getWithResponse(SecurityContactName securityContactName, Context context) {
        Response<SecurityContactInner> inner = this.serviceClient().getWithResponse(securityContactName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SecurityContactImpl((SecurityContactInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SecurityContact get(SecurityContactName securityContactName) {
        SecurityContactInner inner = this.serviceClient().get(securityContactName);
        if (inner != null) {
            return new SecurityContactImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(SecurityContactName securityContactName, Context context) {
        return this.serviceClient().deleteWithResponse(securityContactName, context);
    }

    @Override
    public void delete(SecurityContactName securityContactName) {
        this.serviceClient().delete(securityContactName);
    }

    @Override
    public SecurityContact getById(String id) {
        String securityContactNameLocal = ResourceManagerUtils.getValueFromIdByName(id, "securityContacts");
        if (securityContactNameLocal == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'securityContacts'.", id)));
        }
        SecurityContactName securityContactName = SecurityContactName.fromString(securityContactNameLocal);
        return (SecurityContact)this.getWithResponse(securityContactName, Context.NONE).getValue();
    }

    @Override
    public Response<SecurityContact> getByIdWithResponse(String id, Context context) {
        String securityContactNameLocal = ResourceManagerUtils.getValueFromIdByName(id, "securityContacts");
        if (securityContactNameLocal == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'securityContacts'.", id)));
        }
        SecurityContactName securityContactName = SecurityContactName.fromString(securityContactNameLocal);
        return this.getWithResponse(securityContactName, context);
    }

    @Override
    public void deleteById(String id) {
        String securityContactNameLocal = ResourceManagerUtils.getValueFromIdByName(id, "securityContacts");
        if (securityContactNameLocal == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'securityContacts'.", id)));
        }
        SecurityContactName securityContactName = SecurityContactName.fromString(securityContactNameLocal);
        this.deleteWithResponse(securityContactName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String securityContactNameLocal = ResourceManagerUtils.getValueFromIdByName(id, "securityContacts");
        if (securityContactNameLocal == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'securityContacts'.", id)));
        }
        SecurityContactName securityContactName = SecurityContactName.fromString(securityContactNameLocal);
        return this.deleteWithResponse(securityContactName, context);
    }

    private SecurityContactsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public SecurityContactImpl define(SecurityContactName name) {
        return new SecurityContactImpl(name, this.manager());
    }
}

