/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.security.fluent.SecurityOperatorsClient;
import com.azure.resourcemanager.security.fluent.models.SecurityOperatorInner;
import com.azure.resourcemanager.security.fluent.models.SecurityOperatorListInner;
import com.azure.resourcemanager.security.implementation.SecurityCenterImpl;
import reactor.core.publisher.Mono;

public final class SecurityOperatorsClientImpl
implements SecurityOperatorsClient {
    private final SecurityOperatorsService service;
    private final SecurityCenterImpl client;

    SecurityOperatorsClientImpl(SecurityCenterImpl client) {
        this.service = (SecurityOperatorsService)RestProxy.create(SecurityOperatorsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SecurityOperatorListInner>> listWithResponseAsync(String pricingName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (pricingName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter pricingName is required and cannot be null."));
        }
        String apiVersion = "2023-01-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2023-01-01-preview", this.client.getSubscriptionId(), pricingName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SecurityOperatorListInner>> listWithResponseAsync(String pricingName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (pricingName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter pricingName is required and cannot be null."));
        }
        String apiVersion = "2023-01-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2023-01-01-preview", this.client.getSubscriptionId(), pricingName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SecurityOperatorListInner> listAsync(String pricingName) {
        return this.listWithResponseAsync(pricingName).flatMap(res -> Mono.justOrEmpty((Object)((SecurityOperatorListInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SecurityOperatorListInner> listWithResponse(String pricingName, Context context) {
        return (Response)this.listWithResponseAsync(pricingName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SecurityOperatorListInner list(String pricingName) {
        return (SecurityOperatorListInner)this.listWithResponse(pricingName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SecurityOperatorInner>> getWithResponseAsync(String pricingName, String securityOperatorName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (pricingName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter pricingName is required and cannot be null."));
        }
        if (securityOperatorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityOperatorName is required and cannot be null."));
        }
        String apiVersion = "2023-01-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2023-01-01-preview", this.client.getSubscriptionId(), pricingName, securityOperatorName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SecurityOperatorInner>> getWithResponseAsync(String pricingName, String securityOperatorName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (pricingName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter pricingName is required and cannot be null."));
        }
        if (securityOperatorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityOperatorName is required and cannot be null."));
        }
        String apiVersion = "2023-01-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), "2023-01-01-preview", this.client.getSubscriptionId(), pricingName, securityOperatorName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SecurityOperatorInner> getAsync(String pricingName, String securityOperatorName) {
        return this.getWithResponseAsync(pricingName, securityOperatorName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SecurityOperatorInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SecurityOperatorInner> getWithResponse(String pricingName, String securityOperatorName, Context context) {
        return (Response)this.getWithResponseAsync(pricingName, securityOperatorName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SecurityOperatorInner get(String pricingName, String securityOperatorName) {
        return (SecurityOperatorInner)((Object)this.getWithResponse(pricingName, securityOperatorName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SecurityOperatorInner>> createOrUpdateWithResponseAsync(String pricingName, String securityOperatorName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (pricingName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter pricingName is required and cannot be null."));
        }
        if (securityOperatorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityOperatorName is required and cannot be null."));
        }
        String apiVersion = "2023-01-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), "2023-01-01-preview", this.client.getSubscriptionId(), pricingName, securityOperatorName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SecurityOperatorInner>> createOrUpdateWithResponseAsync(String pricingName, String securityOperatorName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (pricingName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter pricingName is required and cannot be null."));
        }
        if (securityOperatorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityOperatorName is required and cannot be null."));
        }
        String apiVersion = "2023-01-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), "2023-01-01-preview", this.client.getSubscriptionId(), pricingName, securityOperatorName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SecurityOperatorInner> createOrUpdateAsync(String pricingName, String securityOperatorName) {
        return this.createOrUpdateWithResponseAsync(pricingName, securityOperatorName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SecurityOperatorInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SecurityOperatorInner> createOrUpdateWithResponse(String pricingName, String securityOperatorName, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(pricingName, securityOperatorName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SecurityOperatorInner createOrUpdate(String pricingName, String securityOperatorName) {
        return (SecurityOperatorInner)((Object)this.createOrUpdateWithResponse(pricingName, securityOperatorName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String pricingName, String securityOperatorName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (pricingName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter pricingName is required and cannot be null."));
        }
        if (securityOperatorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityOperatorName is required and cannot be null."));
        }
        String apiVersion = "2023-01-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), "2023-01-01-preview", this.client.getSubscriptionId(), pricingName, securityOperatorName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String pricingName, String securityOperatorName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (pricingName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter pricingName is required and cannot be null."));
        }
        if (securityOperatorName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter securityOperatorName is required and cannot be null."));
        }
        String apiVersion = "2023-01-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), "2023-01-01-preview", this.client.getSubscriptionId(), pricingName, securityOperatorName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String pricingName, String securityOperatorName) {
        return this.deleteWithResponseAsync(pricingName, securityOperatorName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String pricingName, String securityOperatorName, Context context) {
        return (Response)this.deleteWithResponseAsync(pricingName, securityOperatorName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String pricingName, String securityOperatorName) {
        this.deleteWithResponse(pricingName, securityOperatorName, Context.NONE);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SecurityCenterSecuri")
    public static interface SecurityOperatorsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/pricings/{pricingName}/securityOperators")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SecurityOperatorListInner>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="pricingName") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/pricings/{pricingName}/securityOperators/{securityOperatorName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SecurityOperatorInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="pricingName") String var4, @PathParam(value="securityOperatorName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/pricings/{pricingName}/securityOperators/{securityOperatorName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SecurityOperatorInner>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="pricingName") String var4, @PathParam(value="securityOperatorName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/pricings/{pricingName}/securityOperators/{securityOperatorName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="pricingName") String var4, @PathParam(value="securityOperatorName") String var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

