/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.SecurityOperatorsClient;
import com.azure.resourcemanager.security.fluent.models.SecurityOperatorInner;
import com.azure.resourcemanager.security.fluent.models.SecurityOperatorListInner;
import com.azure.resourcemanager.security.implementation.SecurityOperatorImpl;
import com.azure.resourcemanager.security.implementation.SecurityOperatorListImpl;
import com.azure.resourcemanager.security.models.SecurityOperator;
import com.azure.resourcemanager.security.models.SecurityOperatorList;
import com.azure.resourcemanager.security.models.SecurityOperators;

public final class SecurityOperatorsImpl
implements SecurityOperators {
    private static final ClientLogger LOGGER = new ClientLogger(SecurityOperatorsImpl.class);
    private final SecurityOperatorsClient innerClient;
    private final SecurityManager serviceManager;

    public SecurityOperatorsImpl(SecurityOperatorsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<SecurityOperatorList> listWithResponse(String pricingName, Context context) {
        Response<SecurityOperatorListInner> inner = this.serviceClient().listWithResponse(pricingName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SecurityOperatorListImpl((SecurityOperatorListInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SecurityOperatorList list(String pricingName) {
        SecurityOperatorListInner inner = this.serviceClient().list(pricingName);
        if (inner != null) {
            return new SecurityOperatorListImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<SecurityOperator> getWithResponse(String pricingName, String securityOperatorName, Context context) {
        Response<SecurityOperatorInner> inner = this.serviceClient().getWithResponse(pricingName, securityOperatorName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SecurityOperatorImpl((SecurityOperatorInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SecurityOperator get(String pricingName, String securityOperatorName) {
        SecurityOperatorInner inner = this.serviceClient().get(pricingName, securityOperatorName);
        if (inner != null) {
            return new SecurityOperatorImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<SecurityOperator> createOrUpdateWithResponse(String pricingName, String securityOperatorName, Context context) {
        Response<SecurityOperatorInner> inner = this.serviceClient().createOrUpdateWithResponse(pricingName, securityOperatorName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SecurityOperatorImpl((SecurityOperatorInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SecurityOperator createOrUpdate(String pricingName, String securityOperatorName) {
        SecurityOperatorInner inner = this.serviceClient().createOrUpdate(pricingName, securityOperatorName);
        if (inner != null) {
            return new SecurityOperatorImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteByResourceGroupWithResponse(String pricingName, String securityOperatorName, Context context) {
        return this.serviceClient().deleteWithResponse(pricingName, securityOperatorName, context);
    }

    @Override
    public void deleteByResourceGroup(String pricingName, String securityOperatorName) {
        this.serviceClient().delete(pricingName, securityOperatorName);
    }

    private SecurityOperatorsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

