/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.security.fluent.SensitivitySettingsClient;
import com.azure.resourcemanager.security.fluent.models.GetSensitivitySettingsListResponseInner;
import com.azure.resourcemanager.security.implementation.SecurityCenterImpl;
import reactor.core.publisher.Mono;

public final class SensitivitySettingsClientImpl
implements SensitivitySettingsClient {
    private final SensitivitySettingsService service;
    private final SecurityCenterImpl client;

    SensitivitySettingsClientImpl(SecurityCenterImpl client) {
        this.service = (SensitivitySettingsService)RestProxy.create(SensitivitySettingsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GetSensitivitySettingsListResponseInner>> listWithResponseAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String apiVersion = "2023-02-15-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2023-02-15-preview", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GetSensitivitySettingsListResponseInner>> listWithResponseAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String apiVersion = "2023-02-15-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2023-02-15-preview", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GetSensitivitySettingsListResponseInner> listAsync() {
        return this.listWithResponseAsync().flatMap(res -> Mono.justOrEmpty((Object)((GetSensitivitySettingsListResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<GetSensitivitySettingsListResponseInner> listWithResponse(Context context) {
        return (Response)this.listWithResponseAsync(context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GetSensitivitySettingsListResponseInner list() {
        return (GetSensitivitySettingsListResponseInner)this.listWithResponse(Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SecurityCenterSensit")
    public static interface SensitivitySettingsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Security/sensitivitySettings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GetSensitivitySettingsListResponseInner>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

