/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.SensitivitySettingsClient;
import com.azure.resourcemanager.security.fluent.models.GetSensitivitySettingsListResponseInner;
import com.azure.resourcemanager.security.implementation.GetSensitivitySettingsListResponseImpl;
import com.azure.resourcemanager.security.models.GetSensitivitySettingsListResponse;
import com.azure.resourcemanager.security.models.SensitivitySettings;

public final class SensitivitySettingsImpl
implements SensitivitySettings {
    private static final ClientLogger LOGGER = new ClientLogger(SensitivitySettingsImpl.class);
    private final SensitivitySettingsClient innerClient;
    private final SecurityManager serviceManager;

    public SensitivitySettingsImpl(SensitivitySettingsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<GetSensitivitySettingsListResponse> listWithResponse(Context context) {
        Response<GetSensitivitySettingsListResponseInner> inner = this.serviceClient().listWithResponse(context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new GetSensitivitySettingsListResponseImpl((GetSensitivitySettingsListResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public GetSensitivitySettingsListResponse list() {
        GetSensitivitySettingsListResponseInner inner = this.serviceClient().list();
        if (inner != null) {
            return new GetSensitivitySettingsListResponseImpl(inner, this.manager());
        }
        return null;
    }

    private SensitivitySettingsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

